package com.thebeastshop.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AccessWayEnum implements CodeEnum<Integer> {
	UNKNOWN(0, "未知"), 
	PC(1, "PC"),
	APP(2, "APP"),
	WAP(3, "WAP"),
	OFFLINE(4, "MS门店"),
    LITTLE_B(5, "Little B门店"),
    APPLET(6,"小程序"),
    HOME_SHOP(7,"HOME门店"),
    TBH_SHOP(8,"TBH门店"),
    POP_SHOP(9,"POP门店"),
    OTHER(99,"其它");

	private Integer code;
	private String name;

	public static final List<AccessWayEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	AccessWayEnum(Integer code,String name) {
		this.code = code;
		this.name = name;
	}

	@Override
	public Integer getCode() {
		return code;
	}

	@Override
	public String getName(){
		return name;
	}

	public static AccessWayEnum getEnumByCode(Integer code) {
		for (AccessWayEnum e : AccessWayEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

    public static String getNameByCode(Integer code) {
        AccessWayEnum accessWayEnum = getEnumByCode(code);
        if (accessWayEnum != null){
            return accessWayEnum.getName();
        }
        return "";
    }
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
