package com.thebeastshop.common.code;

import com.thebeastshop.common.prop.PropPatternProcessor;
import com.thebeastshop.common.utils.CodeGenerator;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-05-21 15:49
 */
public class CodePropProccessor extends PropPatternProcessor {

    public final static String PROP_PREFIX = "code.template";

    public CodePropProccessor() {
        setPrefix(PROP_PREFIX);
    }

    @Override
    public void process(String propName, Object value) {
        if (value == null) {
            return;
        }
        CodeGenerator.getInstance().addCodeTemplate(propName, value.toString());
    }
}
