package com.thebeastshop.common.kafka;

import java.util.List;

import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.concurrent.ListenableFuture;

import com.thebeastshop.common.ByteHandler;

/**
 * Kafka生产者客户端
 */
@SuppressWarnings(value={"unchecked", "rawtypes"})
public class KafkaProducerClient {
	
	private KafkaTemplate kafkaTemplate;

	/**
	 * 发送消息
	 * @param t 消息
	 * @param <T>
     * @return
     */
	public <T extends ByteHandler> boolean send(T t){
		return send(kafkaTemplate.getDefaultTopic(), t);
	}

	/**
	 * 发送消息
	 * @param topic 主题
	 * @param t 消息
	 * @param <T>
     * @return
     */
	public <T extends ByteHandler> boolean send(String topic, T t) {
		return send(topic, null, t);
	}

	/**
	 * 批量发送消息
	 * @param topic 主题
	 * @param list 消息
	 * @param <T>
     */
	public <T extends ByteHandler> void send(String topic,List<T> list){
		for(T t : list){
			send(topic, t);
		}
	}

	/**
	 * 发送消息
	 * @param topic 主题
	 * @param key  键
	 * @param t 消息
	 * @param <T>
     * @return
     */
	public <T extends ByteHandler> boolean send(final String topic, final String key, final T t) {
		ListenableFuture future = kafkaTemplate.send(topic, key, t);
		return future.isDone();
	}

	public KafkaTemplate getKafkaTemplate() {
		return kafkaTemplate;
	}

	public void setKafkaTemplate(KafkaTemplate kafkaTemplate) {
		this.kafkaTemplate = kafkaTemplate;
	}
}
