package com.thebeastshop.common;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

import com.google.common.base.CaseFormat;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;

/**
 * 
 * @author Paul-xiong
 * @date 2018年8月8日
 * @description
 */
public abstract class BaseProto<T> implements ByteHandler {

	private static String GETTER_PREFIX = "get";

	private static String SETTER_PREFIX = "set";

	private Object protoBuilder;

	public BaseProto() {
		super();
		try {
			@SuppressWarnings("unchecked")
			Class<T> clazz = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
			Method method = clazz.getMethod("newBuilder");
			protoBuilder = method.invoke(null);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected Object getProperty(String propertyName) {
		try {
			Method method = protoBuilder.getClass().getMethod(GETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName));
			return method.invoke(protoBuilder);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	protected void setProperty(String propertyName, Object propertyValue) {
		setProperty(propertyName, propertyValue, null);
	}

	protected void setProperty(String propertyName, Object propertyValue, Class<?> clazz) {
		try {
			Method method = protoBuilder.getClass().getMethod(SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName), clazz != null ? clazz : propertyValue.getClass());
			method.invoke(protoBuilder, propertyValue);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public byte[] toByteArray() {
		try {
			Method method = protoBuilder.getClass().getMethod("build");
			Object proto = method.invoke(protoBuilder);
			return (byte[]) proto.getClass().getMethod("toByteArray").invoke(proto);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void mergeFrom(ByteBuffer byteBuffer) {
		try {
			@SuppressWarnings("unchecked")
			Class<T> clazz = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
			Object proto = clazz.getMethod("parseFrom", ByteBuffer.class).invoke(null, byteBuffer);
			protoBuilder.getClass().getMethod("mergeFrom", proto.getClass()).invoke(protoBuilder, proto);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 转成map形式
	 */
	public Map<String, Object> toMap() {
		Map<String, Object> returnMap = new LinkedHashMap<String, Object>();
		try {
			PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
			for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
				String propertyName = propertyDescriptor.getName();
				if ("class".equals(propertyName)) {
					continue;
				}
				Method readMethod = propertyDescriptor.getReadMethod();
				Object result = readMethod.invoke(this, new Object[0]);
				returnMap.put(propertyName, result);
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return returnMap;
	}

	public String toJson() {
		try {
			return JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder) protoBuilder);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
