package com.thebeastshop.common.kafka;

import com.thebeastshop.common.ByteHandler;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.MessageListener;

import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;

public abstract class KafkaBatchConsumerListener<V extends ByteHandler> implements MessageListener<String, ByteBuffer> {

    private final Logger log = LoggerFactory.getLogger(getClass());

    @Override
    public void onMessage(ConsumerRecord<String, ByteBuffer> record) {
        ByteBuffer data = record.value();
        log.info("receive message, type:{}, value:{}", record.value().getClass().getSimpleName(), record.value().toString());
        try {
            String key = record.key();
            Class<?> clazz = getClass(key);
            @SuppressWarnings("unchecked")
            V v = (V) clazz.newInstance();
            v.mergeFrom(data);
            this.processMessage(key, v);
        } catch (Exception e) {
            log.error("消费者端处理消息异常：", e);
        }
    }

    /**
     * 获取消息值对应Class类
     *
     * @param key
     * @return
     */
    public Class<?> getClass(String key) {
        @SuppressWarnings("unchecked")
        Class<V> clazz = (Class<V>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return clazz;
    }

    /**
     * 消息处理逻辑所在的方法，需要子类实现
     * @param key
     * @param v
     */
    public abstract void processMessage(String key,V v);
}
