package com.thebeastshop.common.domain;

import com.thebeastshop.common.converter.*;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-27 16:31
 */
public abstract class AbstractPOJODomain<VO, PO, DTO> extends AbstractBaseDomain<VO, PO> implements BasePOJODomain<VO, PO, DTO> {

    public AbstractPOJODomain() {
    }

    /**
     * 创建类型转换器
     * @return
     */
    @Override
    protected POJOConverter<VO, PO, DTO> createConverter() {
        Class<VO> voClass = getGenericClass(0);
        Class<PO> poClass = getGenericClass(1);
        Class<DTO> dtoClass = getGenericClass(2);
        return new GenericPOJOConverter<>(voClass, poClass, dtoClass);
    }

    @Override
    protected POJOConverter<VO, PO, DTO> getConverter() {
        return (POJOConverter<VO, PO, DTO>) converter;
    }

    @Override
    public Class<DTO> getDTOClass() {
        return getConverter().getDTOClass();
    }

    @Override
    public PO poFromDTO(DTO dto) {
        return getConverter().poFromDTO(dto);
    }

    @Override
    public VO voFromDTO(DTO dto) {
        return getConverter().voFromDTO(dto);
    }

    @Override
    public DTO dtoFromObject(Object obj) {
        return getConverter().dtoFromObject(obj);
    }

    @Override
    public List<PO> poListFromDTOList(List<DTO> dtos) {
        return getConverter().poListFromDTOList(dtos);
    }

    @Override
    public List<DTO> dtoListFromPOList(List<PO> pos) {
        return getConverter().dtoListFromPOList(pos);
    }

    @Override
    public List<DTO> dtoListFromList(List<?> list) {
        return getConverter().dtoListFromList(list);
    }

    @Override
    public <T> ToList<T> from(Class<T> source) {
        return ConverterSupport.from(source);
    }


}
