/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common;

import com.google.common.base.CaseFormat;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.thebeastshop.common.ByteHandler;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseProto<T>
implements ByteHandler {
    private static String GETTER_PREFIX = "get";
    private static String SETTER_PREFIX = "set";
    private Object protoBuilder;

    public BaseProto() {
        try {
            Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Method method = clazz.getMethod("newBuilder", new Class[0]);
            this.protoBuilder = method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object getProperty(String propertyName) {
        try {
            Method method = this.protoBuilder.getClass().getMethod(GETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName), new Class[0]);
            return method.invoke(this.protoBuilder, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setProperty(String propertyName, Object propertyValue) {
        try {
            Method method = this.protoBuilder.getClass().getMethod(SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName), propertyValue.getClass());
            method.invoke(this.protoBuilder, propertyValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            Method method = this.protoBuilder.getClass().getMethod("build", new Class[0]);
            Object proto = method.invoke(this.protoBuilder, new Object[0]);
            return (byte[])proto.getClass().getMethod("toByteArray", new Class[0]).invoke(proto, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mergeFrom(ByteBuffer byteBuffer) {
        try {
            Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Object proto = clazz.getMethod("parseFrom", ByteBuffer.class).invoke(null, byteBuffer);
            this.protoBuilder.getClass().getMethod("mergeFrom", proto.getClass()).invoke(this.protoBuilder, proto);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                if ("class".equals(propertyName)) continue;
                Method readMethod = propertyDescriptor.getReadMethod();
                Object result = readMethod.invoke((Object)this, new Object[0]);
                returnMap.put(propertyName, result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return returnMap;
    }

    public String toJson() {
        try {
            return JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)this.protoBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

