package com.thebeastshop.common.fileupload;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

/**
 * @Author: alexzchen
 * @Date: Created in 2018/7/6
 * @Description: 获取阿里云OSS SecurityToken，用户APP调用Aliyun SDK上传文件
 */
public class OSSSecurityClient {

    public static final String REGION_CN_HANGZHOU = "cn-hangzhou";
    public static final String STS_API_VERSION = "2015-04-01";
    public static final String roleSessionName = "beast";
    public static final String policy = "{\n" +
            "  \"Statement\": [\n" +
            "    {\n" +
            "      \"Action\": [\n" +
            "        \"oss:*\"\n" +
            "      ],\n" +
            "      \"Effect\": \"Allow\",\n" +
            "      \"Resource\": [\"acs:oss:*:*:*\"]\n" +
            "    }\n" +
            "  ],\n" +
            "  \"Version\": \"1\"\n" +
            "}\n";

    private String ossSecurityAccessId;
    private String ossSecurityAccessKey;
    private String ossSecurityRoleArn;               //RAM账号角色名称

    public String getOssSecurityAccessId() {
        return ossSecurityAccessId;
    }

    public void setOssSecurityAccessId(String ossSecurityAccessId) {
        this.ossSecurityAccessId = ossSecurityAccessId;
    }

    public String getOssSecurityAccessKey() {
        return ossSecurityAccessKey;
    }

    public void setOssSecurityAccessKey(String ossSecurityAccessKey) {
        this.ossSecurityAccessKey = ossSecurityAccessKey;
    }

    public String getOssSecurityRoleArn() {
        return ossSecurityRoleArn;
    }

    public void setOssSecurityRoleArn(String ossSecurityRoleArn) {
        this.ossSecurityRoleArn = ossSecurityRoleArn;
    }

	/**
	 * 获取OSS SecurityToken
	 * 
	 * @param durationSeconds
	 *            过期时间（单位秒）
	 * @return
	 * @throws ClientException
	 */
    public OSSSecurityResp getSecurityToken(Long durationSeconds) throws ClientException {
        try {
            // 创建一个 Aliyun Acs Client, 用于发起 OpenAPI 请求
            IClientProfile profile = DefaultProfile.getProfile(REGION_CN_HANGZHOU, this.ossSecurityAccessId, this.ossSecurityAccessKey);
            DefaultAcsClient client = new DefaultAcsClient(profile);

            // 创建一个 AssumeRoleRequest 并设置请求参数
            final AssumeRoleRequest request = new AssumeRoleRequest();
            request.setVersion(STS_API_VERSION);
            request.setMethod(MethodType.POST);
            request.setProtocol(ProtocolType.HTTPS);

            request.setRoleArn(this.ossSecurityRoleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            request.setDurationSeconds(durationSeconds);

            // 发起请求，并得到response
            final AssumeRoleResponse response = client.getAcsResponse(request);

            OSSSecurityResp ossSecurityResp = new OSSSecurityResp();
            ossSecurityResp.setAccessKeyId(response.getCredentials().getAccessKeyId());
            ossSecurityResp.setAccessKeySecret(response.getCredentials().getAccessKeySecret());
            ossSecurityResp.setExpiration(response.getCredentials().getExpiration());
            ossSecurityResp.setStatusCode(200);
            ossSecurityResp.setSecurityToken(response.getCredentials().getSecurityToken());

            return ossSecurityResp;

        } catch (ClientException e) {
            throw e;
        }
    }
}
