package com.thebeastshop.common.enums;

import com.thebeastshop.common.exception.BaseErrorCode;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-09-28 16:10
 */
public enum CommonErrorCode implements BaseErrorCode {

    SYSTEM_ERROR("0999","系统未知异常"),
    ILLEGAL_PARAM("0002","非法参数"),
    NULL_PARAM("0003","参数为空"),
    EMPTY_PARAM("0004", "参数内容为空"),
    RESULT_NULL("0005", "结果为空"),
    RESULT_EMPTY("0006", "结果内容为空"),
    VALID_FAIL("0005", "验证失败"),
    STATUS_NOT_EXPECTED("0006","状态与预期不符"),
    VERSION_NOT_EXPECTED("0007","版本与预期不符"),
    RESULT_NOT_EXPECTED("0008","结果与预期不符"),
    CONVERT_ERROR("0009", "类型转换错误"),
    ROLLBACK_FAILED("0010", "回滚失败"),

    CODE_ENUM_CONV_ERROR("0015", "CodeEnum转换错误"),
    ;


    private String errorCode;
    private String message;

    CommonErrorCode(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    @Override
    public String getPrefix() {
        return "CM";
    }

    @Override
    public String getErrorCode() {
        return getPrefix() + errorCode;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
