/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final String FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYMMDD = "yyMMdd";
    public static final String FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String FORMAT_YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String FORMAT_HH_MM_SS = "HH:mm:ss";
    public static final String FORMAT_HHMMSS = "HHmmss";
    public static final String FORMAT_DD = "dd";
    public static final String FORMAT_MMDD = "MMdd";
    public static final String FORMAT_YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_MICROSECOND = "yyyyMMddHHmmssmmm";
    public static final String FORMAT_DATE_2 = "yyyyMMdd";
    public static final String FORMAT_DATE_3 = "MM/dd/yyyy";
    public static final String FORMAT_DATE_4 = "MM/dd/yyyy HH:mm";
    public static final String FORMAT_MM_DD = "MM-dd";
    public static final String FORMAT_M_YUE_D_RI = "M\u6708d\u65e5";
    public static final String MONGOSTRINGTODATE = "EEE MMM dd HH:mm:ss zzz yyyy";

    public static String date2String(Date date, String format) {
        String result = null;
        if (date == null) {
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = FORMAT_YYYY_MM_DD;
        }
        try {
            result = DateUtil.formatDate(date, format);
        }
        catch (Exception ex) {
            logger.warn("\u65e5\u671f\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u9519\u8bef\uff0c\u65e5\u671f\uff1a" + date.toString() + "\uff0c \u683c\u5f0f\uff1a" + format);
        }
        return result;
    }

    public static String workDays(String strStartDate, String strEndDate) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM_SS);
        Calendar cl1 = Calendar.getInstance();
        Calendar cl2 = Calendar.getInstance();
        try {
            cl1.setTime(df.parse(strStartDate));
            cl2.setTime(df.parse(strEndDate));
        }
        catch (ParseException e) {
            logger.warn("\u65e5\u671f\u683c\u5f0f\u975e\u6cd5");
            e.printStackTrace();
        }
        Long time = cl2.getTimeInMillis() - cl1.getTimeInMillis();
        int count = 0;
        while (cl1.compareTo(cl2) <= 0) {
            if (cl1.get(7) != 7 && cl1.get(7) != 1) {
                ++count;
            }
            cl1.add(5, 1);
        }
        int nDays = DateUtil.nDaysBetweenTwoDate(strStartDate, strEndDate);
        int minute = (int)(time / 60000L);
        int differenceHours = (minute - 1440 * nDays) / 60;
        return count - 1 + "\u5929" + Math.abs(differenceHours) + "\u5c0f\u65f6";
    }

    public static int nDaysBetweenTwoDate(String firstString, String secondString) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM_SS);
        Date firstDate = null;
        Date secondDate = null;
        try {
            firstDate = df.parse(firstString);
            secondDate = df.parse(secondString);
        }
        catch (Exception e) {
            logger.warn("\u65e5\u671f\u578b\u5b57\u7b26\u4e32\u683c\u5f0f\u9519\u8bef");
        }
        int nDay = (int)((secondDate.getTime() - firstDate.getTime()) / 86400000L);
        return nDay;
    }

    public static final Date parseDate_YYYYMMDD(String dateString) {
        return DateUtil.parseDate(dateString, "yyyyMMdd");
    }

    public static final Date parseDate_YYYYMMDDHHMM(String dateString) {
        return DateUtil.parseDate(dateString, FORMAT_YYYYMMDDHHMM);
    }

    public static final Date parseDate_YYYYMMDDHHMMSS(String dateString) {
        return DateUtil.parseDate(dateString, FORMAT_YYYYMMDDHHMMSS);
    }

    public static final Date parseDate(String dateString, String pattern) {
        Date date = null;
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            date = sdf.parse(dateString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static final String formatDate(Date date, String pattern) {
        String v = null;
        try {
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            v = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static final String formatDate_YYYY_MM_DD(Date date) {
        String v = null;
        try {
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
            v = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static final String formatDate_YYYYMMDD(Date date) {
        String v = null;
        try {
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            v = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static boolean isToday(Date date) {
        if (date == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date, (Date)new Date());
    }

    public static boolean isBeforeToday(Date date) {
        if (date == null) {
            return false;
        }
        long today = DateUtils.truncate((Date)new Date(), (int)5).getTime();
        return date.getTime() < today;
    }

    public static boolean isBeforeToday(String dateString, String sFormat) {
        return DateUtil.isBeforeToday(DateUtil.parseDate(dateString, sFormat));
    }

    public static String convertDate(String source, String sformat, String dformat) {
        if (StringUtils.isEmpty((CharSequence)source) || StringUtils.isEmpty((CharSequence)sformat) || StringUtils.isEmpty((CharSequence)dformat)) {
            return source;
        }
        String newString = DateUtil.formatDate(DateUtil.parseDate(source, sformat), dformat);
        return newString == null ? source : newString;
    }

    public static String getCurrDate_HHMMSS() {
        return DateUtil.formatDate(new Date(), FORMAT_HHMMSS);
    }

    public static String getDate_DD(Date date) {
        return DateUtil.formatDate(date, FORMAT_DD);
    }

    public static String getCurrDate_YYYYMMDD() {
        return DateUtil.formatDate(new Date(), "yyyyMMdd");
    }

    public static String getCurrDate_YYYY_MM_DD() {
        return DateUtil.formatDate(new Date(), FORMAT_YYYY_MM_DD);
    }

    public static String getCurrDate_YYYY_MM_DD_HH_MM_SS() {
        return DateUtil.formatDate(new Date(), FORMAT_YYYY_MM_DD_HH_MM_SS);
    }

    public static String getCurrTime_YYYYMMDDHHMMSS() {
        return DateUtil.formatDate(new Date(), FORMAT_YYYYMMDDHHMMSS);
    }

    public static int getYesterDay() {
        Date yesterday = DateUtil.calDate(new Date(), 0, 0, -1);
        return Integer.parseInt(DateUtil.getDate_DD(yesterday));
    }

    public static String getYesterDay_MMDD() {
        Date yesterday = DateUtil.calDate(new Date(), 0, 0, -1);
        return DateUtil.formatDate(yesterday, FORMAT_MMDD);
    }

    public static String getYesterDay_YYYYMMDD() {
        Date yesterday = DateUtil.calDate(new Date(), 0, 0, -1);
        return DateUtil.formatDate(yesterday, "yyyyMMdd");
    }

    public static Date getLastMonthDate(int day) {
        Date lastMonth = DateUtil.calDate(new Date(), 0, -1, 0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastMonth);
        if (day == 31) {
            cal.set(5, cal.getActualMaximum(5));
        } else {
            cal.set(5, day);
        }
        return cal.getTime();
    }

    public static Date getCurMonthDate(int day) {
        Date cur = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(cur);
        if (day == 31) {
            cal.set(5, cal.getActualMaximum(5));
        } else {
            cal.set(5, day);
        }
        return cal.getTime();
    }

    public static boolean isDateString(String dateString, String pattern) {
        boolean v = false;
        try {
            SimpleDateFormat dateFormat;
            Date d;
            if (StringUtils.isNotEmpty((CharSequence)dateString) && (d = (dateFormat = new SimpleDateFormat(pattern)).parse(dateString)) != null) {
                v = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static boolean isNotDateString(String dateString, String pattern) {
        return !DateUtil.isDateString(dateString, pattern);
    }

    public static String calDate(String date, int yearNum, int monthNum, int dateNum) {
        String result = "";
        try {
            SimpleDateFormat sd = new SimpleDateFormat("yyyyMMdd");
            Calendar cal = Calendar.getInstance();
            cal.setTime(sd.parse(date));
            cal.add(2, monthNum);
            cal.add(1, yearNum);
            cal.add(5, dateNum);
            result = sd.format(cal.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date calDate(Date date, int yearNum, int monthNum, int dateNum) {
        Date result = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(2, monthNum);
            cal.add(1, yearNum);
            cal.add(5, dateNum);
            result = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date addDate(Date date, int dateNum) {
        return DateUtil.calDate(date, 0, 0, dateNum);
    }

    public static Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int amount) {
        return DateUtil.add(date, 6, amount);
    }

    public static Date addMin(Date date, int min) {
        Date result = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(12, min);
            result = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date dayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDate(long time) {
        return new Date(time);
    }

    public static boolean isTommorow(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(5, c.get(5) + 1);
        Date yesterday = c.getTime();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
        return format.format(yesterday).equals(format.format(date));
    }

    public static boolean isYesterday(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(5, c.get(5) - 1);
        Date yesterday = c.getTime();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
        return format.format(yesterday).equals(format.format(date));
    }

    public static Date timeStamp2Date(Integer timestampString) {
        Long timestamp = Long.parseLong(timestampString.toString()) * 1000L;
        Date date = new Date(timestamp);
        return date;
    }

    public static boolean isOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }
}

