/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.thebeastshop.common.redis.RedisNamedScript;
import com.thebeastshop.common.redis.RedisScriptManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class RedisScriptScanner
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RedisScriptScanner.class);
    private String location;
    private RedissonClient redissonClient;
    private final RedisScriptManager scriptManager = RedisScriptManager.scriptManager();

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public RedissonClient getRedissonClient() {
        return this.redissonClient;
    }

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public void scan() throws IOException {
        Resource[] resources;
        if (StringUtils.isBlank((CharSequence)this.location)) {
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resolver.getResources(this.location)) {
            URL url = resource.getURL();
            InputStream inputStream = url.openStream();
            String filename = resource.getFilename();
            String name = this.getScriptName(filename);
            try {
                String script = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                RedisNamedScript namedScript = new RedisNamedScript(name, script);
                namedScript.load(this.redissonClient);
                log.info("[Redis] \u626b\u63cf\u5230Redis\u811a\u672c\u6587\u4ef6 [Name: " + name + "] " + "[Path: " + url.getPath() + "] " + "[SHA: " + namedScript.getSha() + "]");
                this.scriptManager.addNamedScript(namedScript);
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    private String getScriptName(String filename) {
        String[] segments = filename.split("/|\\\\");
        return segments[segments.length - 1];
    }

    public void afterPropertiesSet() throws Exception {
        this.scan();
    }
}

