/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.BitSetCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.StringCodec;

public class RedisNamedScript {
    private String name;
    private String sha;
    private String script;

    public RedisNamedScript(String name, String script) {
        this.name = name;
        this.script = script;
    }

    public String getName() {
        return this.name;
    }

    public String getSha() {
        return this.sha;
    }

    public String getScript() {
        return this.script;
    }

    public String load(RedissonClient redissonClient) {
        String sha;
        RScript rScript = redissonClient.getScript();
        this.sha = sha = rScript.scriptLoad(this.script);
        return sha;
    }

    private ScriptInfo getRScriptInfo(Class returnType) {
        if (Boolean.class.isAssignableFrom(returnType)) {
            return new ScriptInfo(RScript.ReturnType.BOOLEAN, (Codec)new BitSetCodec());
        }
        if (Integer.class.isAssignableFrom(returnType) || Long.class.isAssignableFrom(returnType)) {
            return new ScriptInfo(RScript.ReturnType.INTEGER, (Codec)new IntegerCodec());
        }
        if (List.class.isAssignableFrom(returnType)) {
            if (JSONArray.class.isAssignableFrom(returnType)) {
                return new ScriptInfo(RScript.ReturnType.VALUE, (Codec)new StringCodec());
            }
            return new ScriptInfo(RScript.ReturnType.MAPVALUELIST, (Codec)new StringCodec());
        }
        if (Map.class.isAssignableFrom(returnType)) {
            return new ScriptInfo(RScript.ReturnType.VALUE, (Codec)new StringCodec());
        }
        return new ScriptInfo(RScript.ReturnType.VALUE, (Codec)new StringCodec());
    }

    public <T> T eval(RedissonClient redissonClient, Class<T> returnType, RScript.Mode mode, Object ... args) {
        RScript rScript = redissonClient.getScript();
        ScriptInfo scriptInfo = this.getRScriptInfo(returnType);
        Object ret = rScript.evalSha(mode, scriptInfo.getCodec(), this.sha, scriptInfo.getScriptReturnType(), ListUtils.EMPTY_LIST, args);
        T result = this.convertReturnObject(returnType, ret);
        return result;
    }

    public <T> T eval(RedissonClient redissonClient, TypeReference<T> returnType, RScript.Mode mode, Object ... args) {
        RScript rScript = redissonClient.getScript();
        ScriptInfo scriptInfo = new ScriptInfo(RScript.ReturnType.VALUE, (Codec)new StringCodec());
        Object ret = rScript.evalSha(mode, scriptInfo.getCodec(), this.sha, scriptInfo.getScriptReturnType(), ListUtils.EMPTY_LIST, args);
        T result = this.convertReturnObject(returnType, ret);
        return result;
    }

    private <T> T convertReturnObject(Class<T> returnType, Object ret) {
        if (ret instanceof Long) {
            Long lret = (Long)ret;
            if (Integer.class.isAssignableFrom(returnType)) {
                return (T)Integer.valueOf(lret.intValue());
            }
            if (Long.class.isAssignableFrom(returnType)) {
                return (T)lret;
            }
            if (Short.class.isAssignableFrom(returnType)) {
                return (T)Short.valueOf(lret.shortValue());
            }
        }
        if (ret instanceof CharSequence) {
            String strRet = ret.toString();
            if (CharSequence.class.isAssignableFrom(returnType)) {
                return (T)strRet;
            }
            try {
                Object javaRet = JSON.parseObject((String)strRet, returnType);
                return (T)javaRet;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)ret;
    }

    private <T> T convertReturnObject(TypeReference<T> returnType, Object ret) {
        if (ret instanceof CharSequence) {
            String strRet = ret.toString();
            try {
                Object javaRet = JSON.parseObject((String)strRet, returnType, (Feature[])new Feature[0]);
                return (T)javaRet;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)ret;
    }

    public static class ScriptInfo {
        private RScript.ReturnType scriptReturnType;
        private Codec codec;

        public ScriptInfo(RScript.ReturnType scriptReturnType, Codec codec) {
            this.scriptReturnType = scriptReturnType;
            this.codec = codec;
        }

        public RScript.ReturnType getScriptReturnType() {
            return this.scriptReturnType;
        }

        public void setScriptReturnType(RScript.ReturnType scriptReturnType) {
            this.scriptReturnType = scriptReturnType;
        }

        public Codec getCodec() {
            return this.codec;
        }

        public void setCodec(Codec codec) {
            this.codec = codec;
        }
    }
}

