/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.prop;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropPatternProcessor {
    private static final Logger log = LoggerFactory.getLogger(PropPatternProcessor.class);
    protected String prefix;
    protected String suffix;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isMatch(String propName) {
        String pattern;
        if (StringUtils.isEmpty((CharSequence)propName)) {
            return false;
        }
        if (this.getPrefix() == null && this.getSuffix() == null) {
            return false;
        }
        boolean prefixOk = true;
        boolean suffixOk = true;
        StringBuilder builder = new StringBuilder();
        if (this.getPrefix() != null) {
            pattern = this.getPrefix() + ".";
            boolean bl = prefixOk = propName.startsWith(pattern) && propName.length() > pattern.length();
            if (prefixOk) {
                builder.append(" prefix: " + this.getPrefix());
            }
        }
        if (this.getSuffix() != null) {
            pattern = "." + this.getSuffix();
            boolean bl = suffixOk = propName.endsWith(pattern) && propName.length() > pattern.length();
            if (suffixOk) {
                builder.append(" suffix: " + this.suffix);
            }
        }
        if (prefixOk && suffixOk) {
            log.info(" [Prop] Matched property \"" + propName + "\" with [" + builder.toString() + " ]");
            return true;
        }
        return false;
    }

    public abstract void process(String var1, Object var2);

    public void matchAndProcess(String propName, Object value) {
        if (this.isMatch(propName)) {
            this.process(propName, value);
        }
    }
}

