package com.thebeastshop.common.kafka;

import java.lang.reflect.ParameterizedType;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.support.Acknowledgment;

import com.alibaba.fastjson.JSON;

/**
 * Kafka监听器抽象类
 * @param <V>
 */
public abstract class KafkaConsumerListener<V> implements AcknowledgingMessageListener<String, String> {

	private final Logger log = LoggerFactory.getLogger(getClass());

	/**
	 * 重载GenericMessageListener.onMessage方法</BR>
	 * 当消费者端监听到有新的消息进来会调用该方法</BR>
	 * 然后会调用子类实现的processMessage抽象方法
	 * @param record
     */
	@Override
	public void onMessage(ConsumerRecord<String,String> record,Acknowledgment acknowledgment) {
		log.info("receive message:" + record.value());
		V v = JSON.parseObject(record.value(), getClazz());
		this.processMessage(record.key(), v);
		acknowledgment.acknowledge();
	}
	
	public Class<V> getClazz(){
		return (Class <V>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
	}

	/**
	 * 消息处理逻辑所在的方法，需要子类实现
	 * @param key
	 * @param v
     */
	public abstract void processMessage(String key,V v);
}
