/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/**
 * xml工具类
 * 
 * @author Paul-xiong
 * @date 2018年3月22日
 * @description
 */
public class XmlUtil {

	public static String toXml(Object obj) throws Exception {
		String xml = "";
		JAXBContext context = JAXBContext.newInstance(obj.getClass());
		Marshaller marshaller = context.createMarshaller();
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		marshaller.marshal(obj, os);
		xml = os.toString("utf-8");
		return xml;
	}

	@SuppressWarnings("unchecked")
	public static <T> T toObject(String xml, Class<T> clazz) throws Exception {
		T obj = null;
		JAXBContext context = JAXBContext.newInstance(clazz);
		Unmarshaller unmarshaller = context.createUnmarshaller();
		byte[] buf = xml.getBytes("UTF-8");
		obj = (T) unmarshaller.unmarshal(new ByteArrayInputStream(buf));
		return obj;
	}

}
