package com.thebeastshop.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 20:48
 */
public class EnumUtil {

    /**
     * 动态获取枚举对象属性
     * @param id
     * @param cls
     * @param <T>
     * @return
     */
    public static <T, V> V getPropertyById(Integer id, Class<T> cls, String propertyName) {
        if (id == null) return null;
        try {
            Method method = cls.getMethod("getEnumById", new Class[] {Integer.class});
            if (method == null) return null;
            T result = (T) method.invoke(null,new Object[]{id}).toString();
            if (result == null) return null;
            String getterName = "get" + (propertyName.charAt(0) + "").toUpperCase() + propertyName.substring(1);
            Method getterMethod = cls.getMethod(getterName, new Class[] {});
            if (getterMethod == null) return null;
            return (V) getterMethod.invoke(null, new Object[] {});
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 动态获取枚举对象名称
     * @param id
     * @param cls
     * @param <T>
     * @return
     */
    public static <T> String getNameById(Integer id, Class<T> cls) {
        String result = getPropertyById(id, cls, "name");
        return result == null ? "" : result;
    }

}
