package com.thebeastshop.common.converter;

import org.springframework.beans.BeanUtils;

import java.util.*;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-25 17:11
 */
public class GenericBeanConverter implements BeanConverter {

    public <T> ToList<T> from(Class<T> source) {
        return ConverterSupport.from(source);
    }

    protected static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        return ConverterSupport.matchHandlerManager(fromClass, toClass);
    }


    @Override
    public <T> T converterFrom(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        T ret = null;
        try {
            ret = clazz.newInstance();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return null;
        }
        Class fromClass = obj.getClass();
        BeanConverterHandlerManager handlerManager = matchHandlerManager(fromClass, clazz);
        if (handlerManager != null) {
            String[] ignoreFields = handlerManager.getIgnoreFields();
            BeanUtils.copyProperties(obj, ret, ignoreFields);
            handlerManager.afterCopyProperties(obj, ret);
        }
        else {
            BeanUtils.copyProperties(obj, ret);
        }
        return ret;
    }

    @Override
    public <T> List<T> converterListFrom(List list, Class<T> clazz) {
        List<T> results = new ArrayList<>();
        for (Object obj : list) {
            results.add(converterFrom(obj, clazz));
        }
        return results;
    }

    public GenericBeanConverter() {
        init();
    }

    protected void init() {
    }
}
