package com.thebeastshop.common;

/**
 * 含分页的条件类
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-09-07 16:26
 */
public class PageCond extends BaseDO {

    /**
     * 第几页
     */
    private Integer currpage = 1;
    /**
     * 起始数
     */
    private Integer offset = 0;
    /**
     * 每页的数量
     */
    private Integer pagenum = 20;

    public PageCond() {
    }

    public PageCond(Integer currpage, Integer pagenum) {
        setCurrpage(currpage);
        setPagenum(pagenum);
    }


    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
        this.currpage = offset / pagenum + 1;
        if (offset % pagenum > 0) {
            currpage++;
        }
    }

    public Integer getCurrpage() {
        return currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
        this.offset = (currpage - 1) * pagenum;
    }

    public Integer getPagenum() {
        return pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    /**
     * 获取分页 Limit后的 str
     *
     * @return
     */
    public String getCriteriaStr() {
        if (currpage == null) {
            return "";
        }
        Integer pagestart = getPageStart();

        return new StringBuilder(" LIMIT ").append(pagestart).append(",").append(pagenum).append("  ").toString();
    }

    public int getPageStart() {
        return (currpage != null && currpage > 0 ? (currpage - 1) * pagenum : 0);
    }

}
