/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.enums;


/**
 * @author Eric.Lou
 * @version $Id: YesOrNo.java, v 0.1 2016-05-26 下午4:02
 */
public enum YesOrNoEnum {
    YES(1, "是"),
    NO(0, "否"),
    ;

    public final int id;
    public final String name;

    YesOrNoEnum(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static YesOrNoEnum getEnumById(Integer id) {
        for (YesOrNoEnum e : YesOrNoEnum.values()) {
            if (e.getId().equals(id)) {
                return e;
            }
        }
        return null;
    }


}
