package com.thebeastshop.common.code;


import freemarker.template.Configuration;
import freemarker.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-27 14:43
 */
public class FreemarkCodeGenerator implements CodeGenerator {
    protected final static Logger log = LoggerFactory.getLogger(FreemarkCodeGenerator.class);

    private Configuration cfg = new Configuration();

    @Override
    public String generate(String codeTemplateName, String codeTemplate, Map<String, Object> params) {
        String result;
        Template tpl = null;
        try {
            tpl = new Template(codeTemplateName, codeTemplate, cfg);
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (tpl == null) {
            throw new RuntimeException("can't find template for name : " + codeTemplateName);
        } else {
            StringWriter sw = new StringWriter();
            try {
                tpl.process(params, sw);
                result = sw.toString().toUpperCase();
            } catch (Exception e) {
                log.warn("", e);
                throw new RuntimeException("CodeGenerator.generate failed : " + codeTemplateName + " : " + params);
            }
        }
        return result;
    }

}
