/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.exception;

import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.common.prop.PropConstants;

public class BaseServiceException
extends RuntimeException {
    private final String serviceName = PropConstants.getServiceName();
    private final String serviceCode = PropConstants.getServiceCode();
    private String errorCode;

    public BaseServiceException(String errorCode) {
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public BaseServiceException(BaseErrorCode exceptionCode) {
        this(exceptionCode.getErrorCode(), exceptionCode.getMessage());
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg) {
        this(exceptionCode.getErrorCode(), exceptionCode.getMessage() + ": " + msg);
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg, Throwable cause) {
        this(exceptionCode.getErrorCode(), msg, cause);
    }

    public BaseServiceException(String errorCode, String msg) {
        super(msg);
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, String msg, Throwable cause) {
        super(msg, cause);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }
}

