/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.lock;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisDistributLock {
    private final Log log = LogFactory.getLog(this.getClass());
    private final int DEFAULT_SINGLE_EXPIRE_TIME = 3;
    private final int DEFAULT_BATCH_EXPIRE_TIME = 6;
    private JedisPool jedisPool;

    public boolean tryLock(String key) {
        return this.tryLock(key, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(String key, long timeout, TimeUnit unit) {
        Jedis jedis = null;
        try {
            jedis = this.getResource();
            long nano = System.nanoTime();
            do {
                this.log.debug((Object)("try lock key: " + key));
                Long i = jedis.setnx(key, key);
                if (i == 1L) {
                    jedis.expire(key, 3);
                    this.log.debug((Object)("get lock, key: " + key + " , expire in " + 3 + " seconds."));
                    boolean bl = Boolean.TRUE;
                    return bl;
                }
                if (this.log.isDebugEnabled()) {
                    String desc = jedis.get(key);
                    this.log.debug((Object)("key: " + key + " locked by another business\uff1a" + desc));
                }
                if (timeout == 0L) break;
                Thread.sleep(300L);
            } while (System.nanoTime() - nano < unit.toNanos(timeout));
            boolean bl = Boolean.FALSE;
            return bl;
        }
        catch (JedisConnectionException je) {
            this.log.error((Object)je.getMessage(), (Throwable)je);
            this.returnBrokenResource(jedis);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lock(String key) {
        Jedis jedis = null;
        try {
            jedis = this.getResource();
            while (true) {
                this.log.debug((Object)("lock key: " + key));
                Long i = jedis.setnx(key, key);
                if (i == 1L) {
                    jedis.expire(key, 3);
                    this.log.debug((Object)("get lock, key: " + key + " , expire in " + 3 + " seconds."));
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    String desc = jedis.get(key);
                    this.log.debug((Object)("key: " + key + " locked by another business\uff1a" + desc));
                }
                Thread.sleep(300L);
                continue;
                break;
            }
        }
        catch (JedisConnectionException je) {
            this.log.error((Object)je.getMessage(), (Throwable)je);
            this.returnBrokenResource(jedis);
            return;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    public void unLock(String key) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(key);
        this.unLock(list);
    }

    public boolean tryLock(List<String> keyList) {
        return this.tryLock(keyList, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock(List<String> keyList, long timeout, TimeUnit unit) {
        Jedis jedis = null;
        try {
            CopyOnWriteArrayList<String> needLocking = new CopyOnWriteArrayList<String>();
            CopyOnWriteArrayList<String> locked = new CopyOnWriteArrayList<String>();
            jedis = this.getResource();
            long nano = System.nanoTime();
            do {
                Pipeline pipeline = jedis.pipelined();
                for (String key : keyList) {
                    needLocking.add(key);
                    pipeline.setnx(key, key);
                }
                this.log.debug((Object)("try lock keys: " + needLocking));
                List results = pipeline.syncAndReturnAll();
                for (int i = 0; i < results.size(); ++i) {
                    Long result = (Long)results.get(i);
                    String key = (String)needLocking.get(i);
                    if (result != 1L) continue;
                    jedis.expire(key, 6);
                    locked.add(key);
                }
                needLocking.removeAll(locked);
                if (CollectionUtils.isEmpty(needLocking)) {
                    boolean bl = true;
                    this.returnResource(jedis);
                    return bl;
                }
                this.log.debug((Object)("keys: " + needLocking + " locked by another business\uff1a"));
                if (timeout == 0L) break;
                Thread.sleep(500L);
            } while (System.nanoTime() - nano < unit.toNanos(timeout));
            if (!CollectionUtils.isEmpty(locked)) {
                jedis.del(locked.toArray(new String[0]));
            }
            boolean bl = false;
            this.returnResource(jedis);
            return bl;
        }
        catch (JedisConnectionException je) {
            this.log.error((Object)je.getMessage(), (Throwable)je);
            this.returnBrokenResource(jedis);
            this.returnResource(jedis);
            return true;
            {
                catch (Throwable throwable) {
                    this.returnResource(jedis);
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                this.returnResource(jedis);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLock(List<String> keyList) {
        CopyOnWriteArrayList<String> keys = new CopyOnWriteArrayList<String>();
        for (String key : keyList) {
            keys.add(key);
        }
        Jedis jedis = null;
        try {
            jedis = this.getResource();
            jedis.del(keys.toArray(new String[0]));
            this.log.debug((Object)("release lock, keys :" + keys));
        }
        catch (JedisConnectionException je) {
            this.log.error((Object)je.getMessage(), (Throwable)je);
            this.returnBrokenResource(jedis);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    private Jedis getResource() {
        return this.jedisPool.getResource();
    }

    private void returnBrokenResource(Jedis jedis) {
        if (jedis == null) {
            return;
        }
        try {
            this.jedisPool.returnBrokenResource(jedis);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void returnResource(Jedis jedis) {
        if (jedis == null) {
            return;
        }
        try {
            this.jedisPool.returnResource(jedis);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }
}

