/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.BeanUtils;

public class BeanUtil {
    public static <T extends Serializable> T deepClone(T t) {
        return (T)SerializationUtils.clone(t);
    }

    public static <T extends Serializable, S> T deepConvert(S s, Class<T> clazz) {
        String json = JSON.toJSONString(s);
        return (T)((Serializable)JSON.parseObject((String)json, clazz));
    }

    public static <T> T buildFrom(Object src, Class<T> clz) {
        return BeanUtil.buildFrom(src, clz, null);
    }

    public static <T> T buildFrom(Object src, Class<T> clz, String[] ignoreProperties) {
        if (src == null) {
            return null;
        }
        T obj = null;
        try {
            obj = clz.newInstance();
            BeanUtils.copyProperties((Object)src, obj, (String[])ignoreProperties);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static <T> List<T> buildListFrom(Collection src, Class<T> clz) {
        return BeanUtil.buildListFrom(src, clz, null);
    }

    public static <T> List<T> buildListFrom(Collection src, Class<T> clz, String[] ignoreProperties) {
        if (CollectionUtils.isEmpty((Collection)src)) {
            return Collections.emptyList();
        }
        ArrayList<T> objs = new ArrayList<T>(src.size());
        try {
            for (Object o : src) {
                T obj = clz.newInstance();
                BeanUtils.copyProperties(o, obj, (String[])ignoreProperties);
                objs.add(obj);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return objs;
    }
}

