/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String channel, Serializable message) {
        Transaction t = Cat.newTransaction((String)"Redis", (String)"publish");
        try {
            this.redisTemplate.convertAndSend(channel, (Object)message);
            t.setSuccessStatus();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
    }

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public <T> List<T> mutiGet(List<String> keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putCache(String key, T t, Long timeOut, TimeUnit unit) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"set");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            if (timeOut == null) {
                this.redisTemplate.opsForValue().set((Object)key, t);
            } else {
                this.redisTemplate.opsForValue().set((Object)key, t, timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
        }
        finally {
            trans.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getCache(String key) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"get");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redisTemplate.opsForValue().get((Object)key);
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            T t = null;
            return t;
        }
        finally {
            trans.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putHashCache(String key, String hashKey, T t, Long timeOut, TimeUnit unit) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"setHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, t);
            if (timeOut != null) {
                this.redisTemplate.expire((Object)key, timeOut.longValue(), unit);
            }
            trans.setSuccessStatus();
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
        }
        finally {
            trans.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getHashCache(String key, String hashKey) {
        Transaction trans = Cat.newTransaction((String)"Redis", (String)"getHash");
        Cat.logEvent((String)"RedisKey", (String)key);
        try {
            Object t = this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
            trans.setSuccessStatus();
            Object object = t;
            return (T)object;
        }
        catch (Throwable th) {
            this.log.error("redis\u64cd\u4f5c\u5f02\u5e38", th);
            Cat.logError((Throwable)th);
            trans.setStatus(th);
            T t = null;
            return t;
        }
        finally {
            trans.complete();
        }
    }

    public <T> void putCache(String key, T t, Long timeOut) {
        this.putCache(key, t, timeOut, TimeUnit.SECONDS);
    }

    public <T> void putCache(String key, T t) {
        this.putCache(key, t, null, null);
    }

    public <T> void putHashCache(String key, String hashKey, T t) {
        this.putHashCache(key, hashKey, t, null, null);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

