/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.BaseErrorCode;
import com.thebeastshop.common.BeseServiceException;

public class ServiceResp<T>
extends BaseDO {
    private static final long serialVersionUID = 1L;
    private String respCode;
    private String respMsg;
    private boolean isSuccess = true;
    private T bean;

    public static ServiceResp newInstanceSuccess() {
        return ServiceResp.newInstanceSuccess(null);
    }

    public static ServiceResp newInstanceSuccess(Object bean) {
        ServiceResp<Object> serviceResp = new ServiceResp<Object>();
        serviceResp.setBean(bean);
        return serviceResp;
    }

    public static ServiceResp newInstanceFail(String msg) {
        return ServiceResp.newInstanceFail(500, msg);
    }

    public static ServiceResp newInstanceDataNotFoundFail(String msg) {
        return ServiceResp.newInstanceFail(404, msg);
    }

    public static ServiceResp newInstanceFail(Integer code, String msg) {
        return ServiceResp.newInstanceFail(code + "", msg);
    }

    public static ServiceResp newInstanceFail(BaseErrorCode errorCode, String msg) {
        return ServiceResp.newInstanceFail(errorCode.getErrorCode(), errorCode.getMessage() + ": " + msg);
    }

    public static ServiceResp newInstanceFail(BaseErrorCode errorCode) {
        return ServiceResp.newInstanceFail(errorCode.getErrorCode(), errorCode.getMessage());
    }

    public static ServiceResp newInstanceFail(BeseServiceException serviceException) {
        return ServiceResp.newInstanceFail(serviceException.getErrorCode(), serviceException.getMessage());
    }

    public static ServiceResp newInstanceFail(String code, String msg) {
        ServiceResp serviceResp = new ServiceResp();
        serviceResp.setRespCode(code);
        serviceResp.setRespMsg(msg);
        serviceResp.setSuccess(false);
        return serviceResp;
    }

    public String getRespCode() {
        return this.respCode;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public String getRespMsg() {
        return this.respMsg;
    }

    public void setRespMsg(String respMsg) {
        this.respMsg = respMsg;
    }

    public T getBean() {
        return this.bean;
    }

    public void setBean(T bean) {
        this.bean = bean;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }
}

