/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common;

public class Page {
    private int begin;
    private int mySqlBegin;
    private int end;
    private int pageSize;
    private int count;
    private int current;
    private int total;
    private String orderByClause;

    public Page() {
    }

    public Page(int currentPage) {
        this.current = currentPage == 0 ? 1 : currentPage;
        this.pageSize = 15;
        this.begin = (this.current - 1) * this.pageSize + 1;
        this.end = this.current * this.pageSize;
    }

    public Page(int currentPage, String orderByClause) {
        this.current = currentPage == 0 ? 1 : currentPage;
        this.pageSize = 10;
        this.begin = (this.current - 1) * this.pageSize + 1;
        this.end = this.current * this.pageSize;
        this.orderByClause = orderByClause;
    }

    public Page(int currentPage, int pageSize) {
        this.current = currentPage == 0 ? 1 : currentPage;
        this.pageSize = pageSize == 0 ? 10 : pageSize;
        this.begin = (this.current - 1) * this.pageSize + 1;
        this.end = this.current * this.pageSize;
    }

    public Page(int begin, int pageSize, int count) {
        this(begin, pageSize);
        this.count = count;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setBegin(int begin) {
        this.begin = begin;
        if (this.pageSize != 0) {
            this.current = (int)Math.floor((double)this.begin * 1.0 / (double)this.pageSize) + 1;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (this.begin != 0) {
            this.current = (int)Math.floor((double)this.begin * 1.0 / (double)this.pageSize) + 1;
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
        this.total = (int)Math.floor((double)this.count * 1.0 / (double)this.pageSize);
        if (this.count % this.pageSize != 0) {
            ++this.total;
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getTotal() {
        if (this.total == 0) {
            return 1;
        }
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String toString() {
        return "Page [begin=" + this.begin + ", end=" + this.end + ", pageSize=" + this.pageSize + ", count=" + this.count + ", current=" + this.current + ", total=" + this.total + ", orderByClause=" + this.orderByClause + "]";
    }

    public int getMySqlBegin() {
        return this.begin - 1;
    }
}

