/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.aop;

import com.alibaba.fastjson.JSON;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAop {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Object doAround(ProceedingJoinPoint pJoinPoint) {
        try {
            Class<?> clazz = pJoinPoint.getTarget().getClass();
            String className = clazz.getSimpleName();
            String methodName = pJoinPoint.getSignature().getName();
            this.log.info("\u65b9\u6cd5[{}.{}]\u5f00\u59cb\u8c03\u7528", (Object)className, (Object)methodName);
            Object arg = null;
            for (int i = 0; i < pJoinPoint.getArgs().length; ++i) {
                arg = pJoinPoint.getArgs()[i];
                this.log.info("\u65b9\u6cd5[{}.{}]\u53c2\u6570{}:{}", new Object[]{className, methodName, i + 1, JSON.toJSONString((Object)arg)});
            }
            long start = System.currentTimeMillis();
            Object result = pJoinPoint.proceed();
            long end = System.currentTimeMillis();
            this.log.info("\u65b9\u6cd5[{}.{}]\u7ed3\u675f\u8c03\u7528,\u603b\u5171\u8017\u65f6{}\u6beb\u79d2", new Object[]{className, methodName, end - start});
            return result;
        }
        catch (Throwable t) {
            this.log.error("\u7cfb\u7edf\u53d1\u751f\u672a\u77e5\u5f02\u5e38", t);
            return null;
        }
    }
}

