/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    public static final String FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYMMDD = "yyMMdd";
    public static final String FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String FORMAT_YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String FORMAT_HH_MM_SS = "HH:mm:ss";
    public static final String FORMAT_HHMMSS = "HHmmss";
    public static final String FORMAT_DD = "dd";
    public static final String FORMAT_MMDD = "MMdd";

    public static final Date parseDate_YYYYMMDD(String dateString) {
        return DateUtil.parseDate(dateString, FORMAT_YYYYMMDD);
    }

    public static final Date parseDate_YYYYMMDDHHMM(String dateString) {
        return DateUtil.parseDate(dateString, FORMAT_YYYYMMDDHHMM);
    }

    public static final Date parseDate(String dateString, String pattern) {
        Date date = null;
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            date = sdf.parse(dateString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static final String formatDate(Date date, String pattern) {
        String v = null;
        try {
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            v = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static final String formatDate_YYYY_MM_DD(Date date) {
        String v = null;
        try {
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
            v = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static final String formatDate_YYYYMMDD(Date date) {
        String v = null;
        try {
            if (date == null) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_YYYYMMDD);
            v = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static boolean isToday(Date date) {
        if (date == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)date, (Date)new Date());
    }

    public static boolean isBeforeToday(Date date) {
        if (date == null) {
            return false;
        }
        long today = DateUtils.truncate((Date)new Date(), (int)5).getTime();
        return date.getTime() < today;
    }

    public static boolean isBeforeToday(String dateString, String sFormat) {
        return DateUtil.isBeforeToday(DateUtil.parseDate(dateString, sFormat));
    }

    public static String convertDate(String source, String sformat, String dformat) {
        if (StringUtils.isEmpty((CharSequence)source) || StringUtils.isEmpty((CharSequence)sformat) || StringUtils.isEmpty((CharSequence)dformat)) {
            return source;
        }
        String newString = DateUtil.formatDate(DateUtil.parseDate(source, sformat), dformat);
        return newString == null ? source : newString;
    }

    public static String getCurrDate_HHMMSS() {
        return DateUtil.formatDate(new Date(), FORMAT_HHMMSS);
    }

    public static String getDate_DD(Date date) {
        return DateUtil.formatDate(date, FORMAT_DD);
    }

    public static String getCurrDate_YYYYMMDD() {
        return DateUtil.formatDate(new Date(), FORMAT_YYYYMMDD);
    }

    public static String getCurrDate_YYYY_MM_DD() {
        return DateUtil.formatDate(new Date(), FORMAT_YYYY_MM_DD);
    }

    public static String getCurrDate_YYYY_MM_DD_HH_MM_SS() {
        return DateUtil.formatDate(new Date(), FORMAT_YYYY_MM_DD_HH_MM_SS);
    }

    public static String getCurrTime_YYYYMMDDHHMMSS() {
        return DateUtil.formatDate(new Date(), FORMAT_YYYYMMDDHHMMSS);
    }

    public static int getYesterDay() {
        Date yesterday = DateUtil.calDate(new Date(), 0, 0, -1);
        return Integer.parseInt(DateUtil.getDate_DD(yesterday));
    }

    public static String getYesterDay_MMDD() {
        Date yesterday = DateUtil.calDate(new Date(), 0, 0, -1);
        return DateUtil.formatDate(yesterday, FORMAT_MMDD);
    }

    public static String getYesterDay_YYYYMMDD() {
        Date yesterday = DateUtil.calDate(new Date(), 0, 0, -1);
        return DateUtil.formatDate(yesterday, FORMAT_YYYYMMDD);
    }

    public static Date getLastMonthDate(int day) {
        Date lastMonth = DateUtil.calDate(new Date(), 0, -1, 0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastMonth);
        if (day == 31) {
            cal.set(5, cal.getActualMaximum(5));
        } else {
            cal.set(5, day);
        }
        return cal.getTime();
    }

    public static Date getCurMonthDate(int day) {
        Date cur = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(cur);
        if (day == 31) {
            cal.set(5, cal.getActualMaximum(5));
        } else {
            cal.set(5, day);
        }
        return cal.getTime();
    }

    public static boolean isDateString(String dateString, String pattern) {
        boolean v = false;
        try {
            SimpleDateFormat dateFormat;
            Date d;
            if (StringUtils.isNotEmpty((CharSequence)dateString) && (d = (dateFormat = new SimpleDateFormat(pattern)).parse(dateString)) != null) {
                v = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static boolean isNotDateString(String dateString, String pattern) {
        return !DateUtil.isDateString(dateString, pattern);
    }

    public static String calDate(String date, int yearNum, int monthNum, int dateNum) {
        String result = "";
        try {
            SimpleDateFormat sd = new SimpleDateFormat(FORMAT_YYYYMMDD);
            Calendar cal = Calendar.getInstance();
            cal.setTime(sd.parse(date));
            cal.add(2, monthNum);
            cal.add(1, yearNum);
            cal.add(5, dateNum);
            result = sd.format(cal.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date calDate(Date date, int yearNum, int monthNum, int dateNum) {
        Date result = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(2, monthNum);
            cal.add(1, yearNum);
            cal.add(5, dateNum);
            result = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date addDate(Date date, int dateNum) {
        return DateUtil.calDate(date, 0, 0, dateNum);
    }

    public static Date calTime(Date date, int min) {
        Date result = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(12, min);
            result = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date getDate(long time) {
        return new Date(time);
    }

    public static boolean isTommorow(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(5, c.get(5) + 1);
        Date yesterday = c.getTime();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
        return format.format(yesterday).equals(format.format(date));
    }

    public static boolean isYesterday(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.set(5, c.get(5) - 1);
        Date yesterday = c.getTime();
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
        return format.format(yesterday).equals(format.format(date));
    }

    public static Date timeStamp2Date(Integer timestampString) {
        Long timestamp = Long.parseLong(timestampString.toString()) * 1000L;
        Date date = new Date(timestamp);
        return date;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.calTime(new Date(), 30));
    }
}

