/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.redis;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisClient {
    private RedisTemplate redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String channel, Serializable message) {
        Transaction t = Cat.newTransaction((String)"Redis.alibaba", (String)"publish");
        try {
            this.redisTemplate.convertAndSend(channel, (Object)message);
            t.setSuccessStatus();
        }
        catch (Exception e) {
            Cat.logEvent((String)"redis.server", (String)"error-server-ip");
            Cat.logError((Throwable)e);
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
    }

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public <T> void putCache(String key, T t, Long timeOut, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)key, t, timeOut.longValue(), unit);
    }

    public <T> void putCache(String key, T t, Long timeOut) {
        this.redisTemplate.opsForValue().set((Object)key, t, timeOut.longValue(), TimeUnit.SECONDS);
    }

    public <T> void putCache(String key, T t) {
        this.redisTemplate.opsForValue().set((Object)key, t);
    }

    public <T> T getCache(String key) {
        return (T)this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> void putSpaceCache(String nameSpace, String key, T t, Long timeOut, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)(nameSpace + "_" + key), t, timeOut.longValue(), unit);
    }

    public <T> void putSpaceCache(String nameSpace, String key, T t) {
        this.redisTemplate.opsForValue().set((Object)(nameSpace + "_" + key), t);
    }

    public <T> T getSpaceCache(String nameSpace, String key) {
        return (T)this.redisTemplate.opsForValue().get((Object)(nameSpace + "_" + key));
    }

    public <T> void putHashCache(String key, String hashKey, T t, Long timeOut, TimeUnit unit) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, t);
        this.redisTemplate.expire((Object)key, timeOut.longValue(), unit);
    }

    public <T> void putHashCache(String key, String hashKey, T t) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, t);
    }

    public <T> T getHashCache(String key, String hashKey) {
        return (T)this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

