package com.thebeastshop.cart.model;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.model.gift.ScCustomCard;
import com.thebeastshop.cart.model.gift.ScGiftCampaignVO;
import com.thebeastshop.common.BaseDO;

import java.util.List;

/**
 * 购物车pack
 *
 * @author feiLong.gao
 * @date 2019/12/25
 */
public class ScPackVO extends BaseDO {

    /**
     * 商品包ID
     */
    private Long id;
    /**
     * 数量
     */
    private int count = 1;

    /**
     * 商品包来源
     */
    private CartPackSourceEnum source = CartPackSourceEnum.RAW;
    /**
     * 商品code
     */
    private String productId;
    /**
     * spv信息
     */
    private ScSpvVO spv;
    /**
     * 是否包含规格
     */
    private Boolean hasVariants = false;
    /**
     * 标签
     */
    private List<ScLabel> labels = Lists.newArrayList();
    /**
     * 赠品商品
     */
    private List<ScGiftCampaignVO> giftPacks;
    /**
     * 是否已获得（加价购才有）
     */
    private Boolean owned = false;

    /**
     * 是否定制商品
     */
    private Boolean customizable = false;

    /**
     * 该商品用户是否已经定制过，若定制过，则不允许用户再修改 spv 信息
     */
    private Boolean customized = false;

    /**
     * 定制属性集
     */
    private List<ScUserSingleCustomization> customizes;
    /**
     * 权益对象
     */
    private ScCartBenefit benefit;
    /**
     * 参加的赠品活动
     */
    private ScCampaignTag campaign;

    /**
     * 失效信息，商品包不可选信息
     */
    private ScInvalid invalid = new ScInvalid();

    /**
     * 活动区间ID
     */
    private Integer campaignSectionId;

    /**
     * 定制商品代写卡片
     */
    private ScCustomCard customCard;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public CartPackSourceEnum getSource() {
        return source;
    }

    public void setSource(CartPackSourceEnum source) {
        this.source = source;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public ScSpvVO getSpv() {
        return spv;
    }

    public void setSpv(ScSpvVO spv) {
        this.spv = spv;
    }

    public Boolean getHasVariants() {
        return hasVariants;
    }

    public void setHasVariants(Boolean hasVariants) {
        this.hasVariants = hasVariants;
    }

    public List<ScLabel> getLabels() {
        return labels;
    }

    public void setLabels(List<ScLabel> labels) {
        this.labels = labels;
    }

    public List<ScGiftCampaignVO> getGiftPacks() {
        return giftPacks;
    }

    public void setGiftPacks(List<ScGiftCampaignVO> giftPacks) {
        this.giftPacks = giftPacks;
    }

    public Boolean getOwned() {
        return owned;
    }

    public void setOwned(Boolean owned) {
        this.owned = owned;
    }

    public Boolean getCustomizable() {
        return customizable;
    }

    public void setCustomizable(Boolean customizable) {
        this.customizable = customizable;
    }

    public Boolean getCustomized() {
        return customized;
    }

    public void setCustomized(Boolean customized) {
        this.customized = customized;
    }

    public List<ScUserSingleCustomization> getCustomizes() {
        return customizes;
    }

    public void setCustomizes(List<ScUserSingleCustomization> customizes) {
        this.customizes = customizes;
    }

    public ScCartBenefit getBenefit() {
        return benefit;
    }

    public void setBenefit(ScCartBenefit benefit) {
        this.benefit = benefit;
    }

    public ScCampaignTag getCampaign() {
        return campaign;
    }

    public void setCampaign(ScCampaignTag campaign) {
        this.campaign = campaign;
    }

    public ScInvalid getInvalid() {
        return invalid;
    }

    public void setInvalid(ScInvalid invalid) {
        this.invalid = invalid;
    }

    public Integer getCampaignSectionId() {
        return campaignSectionId;
    }

    public void setCampaignSectionId(Integer campaignSectionId) {
        this.campaignSectionId = campaignSectionId;
    }

    public ScCustomCard getCustomCard() {
        return customCard;
    }

    public void setCustomCard(ScCustomCard customCard) {
        this.customCard = customCard;
    }
}
