/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.thebeastshop.bi.dao.ReportingDataChannelSaleMapper;
import com.thebeastshop.bi.dto.ReportingDataChannelSaleDTO;
import com.thebeastshop.bi.po.ReportingDataChannelSale;
import com.thebeastshop.bi.po.ReportingDataChannelSaleExample;
import com.thebeastshop.bi.service.ReportingDataChannelSaleService;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.common.validation.Validation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportingDataChannelSaleServiceImpl
implements ReportingDataChannelSaleService {
    @Autowired
    private ReportingDataChannelSaleMapper reportingDataChannelSaleMapper;

    public List<ReportingDataChannelSaleDTO> getChannelSale(List<String> channelList) {
        Validation.paramNotNull(channelList, (String)"\u67e5\u8be2\u65f6\u6e20\u9053List\u4e3a\u7a7a");
        ArrayList<ReportingDataChannelSaleDTO> list = new ArrayList<ReportingDataChannelSaleDTO>();
        ReportingDataChannelSaleExample example = new ReportingDataChannelSaleExample();
        if (!CollectionUtils.isNotEmpty(channelList)) {
            return list;
        }
        example.createCriteria().andChannelCodeIn(channelList).andPayDateGreaterThanOrEqualTo(this.getLastWeek());
        List record = this.reportingDataChannelSaleMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)record)) {
            return null;
        }
        for (ReportingDataChannelSale reportingDataChannelSale : record) {
            ReportingDataChannelSaleDTO dto = (ReportingDataChannelSaleDTO)BeanUtil.buildFrom((Object)reportingDataChannelSale, ReportingDataChannelSaleDTO.class);
            list.add(dto);
        }
        return list;
    }

    public Date getLastWeek() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -7);
        Date d = c.getTime();
        return d;
    }
}

