/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.thebeastshop.bi.dao.ReportingBaseBiChartMapper;
import com.thebeastshop.bi.dto.ReportingBaseBiChartDTO;
import com.thebeastshop.bi.enums.ChartTypeEnum;
import com.thebeastshop.bi.po.ReportingBaseBiChart;
import com.thebeastshop.bi.service.ReportingBaseBiChartService;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.validation.Validation;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportingBaseBiChartServiceImpl
implements ReportingBaseBiChartService {
    @Autowired
    private ReportingBaseBiChartMapper reportingBaseBiChartMapper;

    public Integer createBiChartConfig(ReportingBaseBiChartDTO dto) {
        ReportingBaseBiChart record = (ReportingBaseBiChart)BeanUtil.buildFrom((Object)dto, ReportingBaseBiChart.class);
        record.setType(dto.getType().getCode());
        record.setDimensions(dto.getDimensions().toString());
        if (this.reportingBaseBiChartMapper.insertSelective(record) > 0) {
            return record.getId();
        }
        return 0;
    }

    public boolean updateBiChartConfig(ReportingBaseBiChartDTO dto) {
        ReportingBaseBiChart record = (ReportingBaseBiChart)BeanUtil.buildFrom((Object)dto, ReportingBaseBiChart.class);
        record.setType(dto.getType().getCode());
        record.setDimensions(dto.getDimensions().toString());
        return this.reportingBaseBiChartMapper.updateByPrimaryKey(record) > 0;
    }

    public ReportingBaseBiChartDTO queryBiChartConfigById(Integer id) {
        Validation.paramNotNull((Object)id, (String)"\u67e5\u8be2\u56fe\u8868\u914d\u7f6e\u65f6ID\u4e3a\u7a7a");
        ReportingBaseBiChart record = this.reportingBaseBiChartMapper.selectByPrimaryKey(id);
        if (record == null) {
            return null;
        }
        return this.toExchgSpuConfigVO(record);
    }

    private ReportingBaseBiChartDTO toExchgSpuConfigVO(ReportingBaseBiChart record) {
        ReportingBaseBiChartDTO dto = (ReportingBaseBiChartDTO)BeanUtil.buildFrom((Object)record, ReportingBaseBiChartDTO.class);
        dto.setType(ChartTypeEnum.getEnumByCode((Integer)record.getType()));
        if (EmptyUtil.isNotEmpty((String)record.getDimensions())) {
            JSONObject jsonObject = JSONObject.fromObject((Object)record.getDimensions());
            dto.setDimensions((Object)jsonObject);
        }
        return dto;
    }

    public boolean deleteBiChartConfigById(Integer id) {
        return this.reportingBaseBiChartMapper.deleteByPrimaryKey(id) > 0;
    }
}

