/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bi.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.github.pagehelper.util.StringUtil;
import com.thebeastshop.bi.dao.OpCrmMemberMapper;
import com.thebeastshop.bi.dao.OpMemberLabelBasicMapper;
import com.thebeastshop.bi.dao.OpMemberLabelBasicMultipleMapper;
import com.thebeastshop.bi.dao.OpMemberLabelBehaviourMapper;
import com.thebeastshop.bi.dao.OpMemberLabelBehaviourMultipleMapper;
import com.thebeastshop.bi.dao.OpMemberLabelConsumeMapper;
import com.thebeastshop.bi.dao.OpMemberLabelConsumeMultipleMapper;
import com.thebeastshop.bi.dao.OpMemberLabelMapper;
import com.thebeastshop.bi.dao.OpMemberLabelQuerysqlMapper;
import com.thebeastshop.bi.dto.OpMemberLabelEffectiveDTO;
import com.thebeastshop.bi.dto.OpMemberLabelQueryDTO;
import com.thebeastshop.bi.enums.BasicMultipleTypeEnum;
import com.thebeastshop.bi.po.OpCrmMemberExample;
import com.thebeastshop.bi.po.OpMemberLabel;
import com.thebeastshop.bi.po.OpMemberLabelBasic;
import com.thebeastshop.bi.po.OpMemberLabelBasicExample;
import com.thebeastshop.bi.po.OpMemberLabelBasicMultiple;
import com.thebeastshop.bi.po.OpMemberLabelBasicMultipleExample;
import com.thebeastshop.bi.po.OpMemberLabelBehaviour;
import com.thebeastshop.bi.po.OpMemberLabelBehaviourExample;
import com.thebeastshop.bi.po.OpMemberLabelBehaviourMultiple;
import com.thebeastshop.bi.po.OpMemberLabelBehaviourMultipleExample;
import com.thebeastshop.bi.po.OpMemberLabelConsume;
import com.thebeastshop.bi.po.OpMemberLabelConsumeExample;
import com.thebeastshop.bi.po.OpMemberLabelConsumeMultiple;
import com.thebeastshop.bi.po.OpMemberLabelConsumeMultipleExample;
import com.thebeastshop.bi.po.OpMemberLabelExample;
import com.thebeastshop.bi.po.OpMemberLabelQuerysql;
import com.thebeastshop.bi.po.OpMemberLabelQuerysqlExample;
import com.thebeastshop.bi.service.OpMemberLabelService;
import com.thebeastshop.bi.vo.OpCrmMemberVO;
import com.thebeastshop.bi.vo.OpMemberLabelBasicMultipleVO;
import com.thebeastshop.bi.vo.OpMemberLabelBasicVO;
import com.thebeastshop.bi.vo.OpMemberLabelBehaviourMultipleVO;
import com.thebeastshop.bi.vo.OpMemberLabelBehaviourVO;
import com.thebeastshop.bi.vo.OpMemberLabelConsumeMultipleVO;
import com.thebeastshop.bi.vo.OpMemberLabelConsumeVO;
import com.thebeastshop.bi.vo.OpMemberLabelEffectiveVO;
import com.thebeastshop.bi.vo.OpMemberLabelVO;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.converter.BeanConverter;
import com.thebeastshop.common.converter.GenericBeanConverter;
import com.thebeastshop.common.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="opMemberLabelService")
public class OpMemberLabelServiceImpl
implements OpMemberLabelService {
    @Autowired
    private OpMemberLabelMapper opMemberLabelMapper;
    @Autowired
    private OpMemberLabelBasicMapper opMemberLabelBasicMapper;
    @Autowired
    private OpMemberLabelBasicMultipleMapper opMemberLabelBasicMultipleMapper;
    @Autowired
    private OpMemberLabelBehaviourMapper opMemberLabelBehaviourMapper;
    @Autowired
    private OpMemberLabelBehaviourMultipleMapper opMemberLabelBehaviourMultipleMapper;
    @Autowired
    private OpMemberLabelConsumeMapper opMemberLabelConsumeMapper;
    @Autowired
    private OpMemberLabelConsumeMultipleMapper opMemberLabelConsumeMultipleMapper;
    @Autowired
    private OpMemberLabelQuerysqlMapper opMemberLabelQuerysqlMapper;
    @Autowired
    private OpCrmMemberMapper opCrmMemberMapper;
    private BeanConverter beanConverter = new GenericBeanConverter();

    public PageQueryResp<OpMemberLabelVO> queryMemberLabelPageByDto(OpMemberLabelQueryDTO dto) {
        PageQueryResp page = new PageQueryResp();
        OpMemberLabelExample example = new OpMemberLabelExample();
        OpMemberLabelExample.Criteria criteria = example.createCriteria();
        this.criteriaDTO(criteria, dto);
        int count = this.opMemberLabelMapper.countByExample(example);
        if (count > 0) {
            example.setOrderByClause("create_time desc");
            example.setCriteriaStr(dto.getBiCriteriaStr());
            List labelList = this.opMemberLabelMapper.selectByExample(example);
            List resultList = this.beanConverter.converterListFrom(labelList, OpMemberLabelVO.class);
            page.setBeanList(resultList);
            page.setPageSize(dto.getPagenum());
            page.setPageNo(dto.getCurrpage());
            page.setTotalCnt(Integer.valueOf(count));
        }
        return page;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public boolean addMemberLabel(OpMemberLabelVO labelVo) throws Exception {
        if (labelVo == null) throw new Exception("\u65b0\u589e\u6570\u636e\u4e3a\u7a7a");
        String labelName = labelVo.getName();
        if (StringUtils.isEmpty((String)labelName)) {
            throw new Exception("\u6807\u7b7e\u540d\u79f0\u4e3a\u7a7a");
        }
        OpMemberLabel label = new OpMemberLabel();
        label.setName(labelName);
        label.setCreateOperatorId(labelVo.getCreateOperatorId());
        label.setCreateOperatorName(labelVo.getCreateOperatorName());
        label.setCreateTime(new Date());
        if (this.opMemberLabelMapper.insertSelective(label) <= 0) throw new Exception("\u6807\u7b7e\u8868\u65b0\u589e\u5931\u8d25");
        Integer labelId = label.getId();
        if (labelId > 0) {
            OpMemberLabelBehaviourMultiple multiple;
            if (labelVo.getBasic() != null) {
                OpMemberLabelBasicVO basicVO = labelVo.getBasic();
                OpMemberLabelBasic basic = new OpMemberLabelBasic();
                basicVO.setLabelId(labelId);
                BeanUtils.copyProperties((Object)basic, (Object)basicVO);
                if (this.opMemberLabelBasicMapper.insertSelective(basic) <= 0) throw new Exception("\u6807\u7b7e-\u57fa\u672c\u5c5e\u6027\u8868\u65b0\u589e\u5931\u8d25");
                Integer basicId = basic.getId();
                basicVO.setId(basicId);
                List basicMultipleVO = basicVO.getMultipleList();
                if (CollectionUtils.isNotEmpty((Collection)basicMultipleVO)) {
                    for (OpMemberLabelBasicMultipleVO mu : basicMultipleVO) {
                        OpMemberLabelBasicMultiple m = new OpMemberLabelBasicMultiple();
                        mu.setLabelBasicId(basicId);
                        BeanUtils.copyProperties((Object)m, (Object)mu);
                        this.opMemberLabelBasicMultipleMapper.insertSelective(m);
                        mu.setId(m.getId());
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)labelVo.getBehaviour())) {
                List behaviourList = labelVo.getBehaviour();
                for (OpMemberLabelBehaviourVO be : behaviourList) {
                    OpMemberLabelBehaviour behaviour = new OpMemberLabelBehaviour();
                    be.setLabelId(labelId);
                    BeanUtils.copyProperties((Object)behaviour, (Object)be);
                    if (this.opMemberLabelBehaviourMapper.insertSelective(behaviour) <= 0) throw new Exception("\u6807\u7b7e-\u884c\u4e3a\u6570\u636e\u8868\u65b0\u589e\u5931\u8d25");
                    Integer behaviourId = behaviour.getId();
                    be.setId(behaviourId);
                    List behaviourMultipleVO = be.getMultipleList();
                    if (!CollectionUtils.isNotEmpty((Collection)behaviourMultipleVO)) continue;
                    for (OpMemberLabelBehaviourMultipleVO multipleVO : behaviourMultipleVO) {
                        multiple = new OpMemberLabelBehaviourMultiple();
                        multipleVO.setLabelBehaviourId(behaviourId);
                        BeanUtils.copyProperties((Object)multiple, (Object)multipleVO);
                        this.opMemberLabelBehaviourMultipleMapper.insertSelective(multiple);
                        multipleVO.setId(multiple.getId());
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)labelVo.getConsume())) {
                List consumeList = labelVo.getConsume();
                for (OpMemberLabelConsumeVO co : consumeList) {
                    OpMemberLabelConsume consume = new OpMemberLabelConsume();
                    co.setLabelId(labelId);
                    BeanUtils.copyProperties((Object)consume, (Object)co);
                    if (this.opMemberLabelConsumeMapper.insertSelective(consume) <= 0) throw new Exception("\u6807\u7b7e-\u6d88\u8d39\u4e60\u60ef\u65b0\u589e\u5931\u8d25");
                    Integer consumeId = consume.getId();
                    co.setId(consumeId);
                    List multipleList = co.getMultipleList();
                    if (!CollectionUtils.isNotEmpty((Collection)multipleList)) continue;
                    for (OpMemberLabelConsumeMultipleVO mu : multipleList) {
                        multiple = new OpMemberLabelConsumeMultiple();
                        mu.setLabelConsumeId(consumeId);
                        BeanUtils.copyProperties((Object)multiple, (Object)mu);
                        this.opMemberLabelConsumeMultipleMapper.insertSelective((OpMemberLabelConsumeMultiple)multiple);
                        mu.setId(multiple.getId());
                    }
                }
            }
        }
        this.insertLabelSQL(labelId, this.getInsertLabelSQL(labelVo));
        return true;
    }

    public boolean updateMemberLabel(OpMemberLabelVO labelVo) throws Exception {
        if (labelVo != null) {
            String labelName = labelVo.getName();
            if (StringUtils.isEmpty((String)labelName)) {
                throw new Exception("\u6807\u7b7e\u540d\u79f0\u4e3a\u7a7a");
            }
            OpMemberLabel label = new OpMemberLabel();
            label.setId(labelVo.getId());
            label.setName(labelName);
            this.opMemberLabelMapper.updateByPrimaryKeySelective(label);
            OpMemberLabelBasicVO basicVO = labelVo.getBasic();
            OpMemberLabelBasicExample basicExample = new OpMemberLabelBasicExample();
            basicExample.createCriteria().andLabelIdEqualTo(labelVo.getId());
            List oldBasic = this.opMemberLabelBasicMapper.selectByExample(basicExample);
            if (basicVO != null) {
                Integer basicId;
                List basicMultipleVO = basicVO.getMultipleList();
                OpMemberLabelBasic basic = new OpMemberLabelBasic();
                basicVO.setLabelId(label.getId());
                BeanUtils.copyProperties((Object)basic, (Object)basicVO);
                if (CollectionUtils.isNotEmpty((Collection)oldBasic)) {
                    basicId = ((OpMemberLabelBasic)oldBasic.get(0)).getId();
                    basic.setId(basicId);
                    this.opMemberLabelBasicMapper.updateByPrimaryKey(basic);
                    OpMemberLabelBasicMultipleExample example = new OpMemberLabelBasicMultipleExample();
                    example.createCriteria().andLabelBasicIdEqualTo(basicId);
                    this.opMemberLabelBasicMultipleMapper.deleteByExample(example);
                } else {
                    this.opMemberLabelBasicMapper.insertSelective(basic);
                    basicId = basic.getId();
                    basicVO.setId(basicId);
                }
                if (CollectionUtils.isNotEmpty((Collection)basicMultipleVO)) {
                    for (OpMemberLabelBasicMultipleVO mu : basicMultipleVO) {
                        OpMemberLabelBasicMultiple m = new OpMemberLabelBasicMultiple();
                        mu.setLabelBasicId(basicId);
                        BeanUtils.copyProperties((Object)m, (Object)mu);
                        this.opMemberLabelBasicMultipleMapper.insert(m);
                        mu.setId(m.getId());
                    }
                }
            } else if (CollectionUtils.isNotEmpty((Collection)oldBasic)) {
                OpMemberLabelBasicMultipleExample example = new OpMemberLabelBasicMultipleExample();
                example.createCriteria().andLabelBasicIdEqualTo(((OpMemberLabelBasic)oldBasic.get(0)).getId());
                List oldBasicMultiple = this.opMemberLabelBasicMultipleMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty((Collection)oldBasicMultiple)) {
                    this.opMemberLabelBasicMultipleMapper.deleteByExample(example);
                }
                this.opMemberLabelBasicMapper.deleteByPrimaryKey(((OpMemberLabelBasic)oldBasic.get(0)).getId());
            }
            List behaviourList = labelVo.getBehaviour();
            OpMemberLabelBehaviourExample behaviourExample = new OpMemberLabelBehaviourExample();
            behaviourExample.createCriteria().andLabelIdEqualTo(labelVo.getId());
            List oldBehaviourList = this.opMemberLabelBehaviourMapper.selectByExample(behaviourExample);
            if (CollectionUtils.isNotEmpty((Collection)oldBehaviourList)) {
                ArrayList<Integer> beIds = new ArrayList<Integer>(oldBehaviourList.size());
                for (OpMemberLabelBehaviour be : oldBehaviourList) {
                    beIds.add(be.getId());
                }
                OpMemberLabelBehaviourMultipleExample channelExample = new OpMemberLabelBehaviourMultipleExample();
                channelExample.createCriteria().andLabelBehaviourIdIn(beIds);
                this.opMemberLabelBehaviourMultipleMapper.deleteByExample(channelExample);
                this.opMemberLabelBehaviourMapper.deleteByExample(behaviourExample);
            }
            if (CollectionUtils.isNotEmpty((Collection)behaviourList)) {
                for (OpMemberLabelBehaviourVO be : behaviourList) {
                    OpMemberLabelBehaviour behaviour = new OpMemberLabelBehaviour();
                    be.setLabelId(labelVo.getId());
                    BeanUtils.copyProperties((Object)behaviour, (Object)be);
                    if (this.opMemberLabelBehaviourMapper.insert(behaviour) > 0) {
                        Integer behaviourId = behaviour.getId();
                        be.setId(behaviourId);
                        List behaviourMultipleList = be.getMultipleList();
                        if (!CollectionUtils.isNotEmpty((Collection)behaviourMultipleList)) continue;
                        for (OpMemberLabelBehaviourMultipleVO mu : behaviourMultipleList) {
                            OpMemberLabelBehaviourMultiple multiple = new OpMemberLabelBehaviourMultiple();
                            mu.setLabelBehaviourId(behaviourId);
                            BeanUtils.copyProperties((Object)multiple, (Object)mu);
                            this.opMemberLabelBehaviourMultipleMapper.insert(multiple);
                            mu.setId(multiple.getId());
                        }
                        continue;
                    }
                    throw new Exception("\u6807\u7b7e-\u884c\u4e3a\u6570\u636e\u8868\u65b0\u589e\u5931\u8d25");
                }
            }
            List consumeList = labelVo.getConsume();
            OpMemberLabelConsumeExample consumeExample = new OpMemberLabelConsumeExample();
            consumeExample.createCriteria().andLabelIdEqualTo(labelVo.getId());
            List oldConsumeList = this.opMemberLabelConsumeMapper.selectByExample(consumeExample);
            if (CollectionUtils.isNotEmpty((Collection)oldConsumeList)) {
                ArrayList<Integer> coIds = new ArrayList<Integer>(oldConsumeList.size());
                for (OpMemberLabelConsume co : oldConsumeList) {
                    coIds.add(co.getId());
                }
                OpMemberLabelConsumeMultipleExample consumeMultipleExample = new OpMemberLabelConsumeMultipleExample();
                consumeMultipleExample.createCriteria().andLabelConsumeIdIn(coIds);
                this.opMemberLabelConsumeMultipleMapper.deleteByExample(consumeMultipleExample);
                this.opMemberLabelConsumeMapper.deleteByExample(consumeExample);
            }
            if (CollectionUtils.isNotEmpty((Collection)consumeList)) {
                for (OpMemberLabelConsumeVO co : consumeList) {
                    OpMemberLabelConsume consume = new OpMemberLabelConsume();
                    co.setLabelId(labelVo.getId());
                    BeanUtils.copyProperties((Object)consume, (Object)co);
                    if (this.opMemberLabelConsumeMapper.insert(consume) > 0) {
                        Integer consumeId = consume.getId();
                        co.setId(consumeId);
                        List multipleList = co.getMultipleList();
                        if (!CollectionUtils.isNotEmpty((Collection)multipleList)) continue;
                        for (OpMemberLabelConsumeMultipleVO mu : multipleList) {
                            OpMemberLabelConsumeMultiple multiple = new OpMemberLabelConsumeMultiple();
                            mu.setLabelConsumeId(consumeId);
                            BeanUtils.copyProperties((Object)multiple, (Object)mu);
                            this.opMemberLabelConsumeMultipleMapper.insertSelective(multiple);
                            mu.setId(multiple.getId());
                        }
                        continue;
                    }
                    throw new Exception("\u6807\u7b7e-\u6d88\u8d39\u4e60\u60ef\u65b0\u589e\u5931\u8d25");
                }
            }
        } else {
            throw new Exception("\u65b0\u589e\u6570\u636e\u4e3a\u7a7a");
        }
        this.insertLabelSQL(labelVo.getId(), this.getInsertLabelSQL(labelVo));
        return true;
    }

    private void criteriaDTO(OpMemberLabelExample.Criteria criteria, OpMemberLabelQueryDTO dto) {
        if (dto != null) {
            if (dto.getId() != null) {
                criteria.andIdEqualTo(dto.getId());
            }
            if (!StringUtil.isEmpty((String)dto.getName())) {
                criteria.andNameLike("%" + dto.getName() + "%");
            }
            if (dto.getCreateOperateId() != null) {
                criteria.andCreateOperatorIdEqualTo(dto.getCreateOperateId());
            }
            if (!StringUtil.isEmpty((String)dto.getCreateOperateName())) {
                criteria.andCreateOperatorNameEqualTo(dto.getCreateOperateName());
            }
            if (CollectionUtils.isNotEmpty((Collection)dto.getCreatorIds())) {
                criteria.andCreateOperatorIdIn(dto.getCreatorIds());
            }
        }
    }

    public OpMemberLabelVO getDetail(Integer labelId) throws Exception {
        OpMemberLabelBasicMultipleVO multipleVO;
        if (labelId == null) {
            return null;
        }
        OpMemberLabelVO labelVO = new OpMemberLabelVO();
        OpMemberLabel label = this.opMemberLabelMapper.selectByPrimaryKey(labelId);
        if (label == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)labelVO, (Object)label);
        OpMemberLabelBasicExample basicExample = new OpMemberLabelBasicExample();
        basicExample.createCriteria().andLabelIdEqualTo(labelId);
        List basicList = this.opMemberLabelBasicMapper.selectByExample(basicExample);
        if (CollectionUtils.isNotEmpty((Collection)basicList)) {
            OpMemberLabelBasic basic = (OpMemberLabelBasic)basicList.get(0);
            OpMemberLabelBasicVO basicVO = new OpMemberLabelBasicVO();
            BeanUtils.copyProperties((Object)basicVO, (Object)basic);
            OpMemberLabelBasicMultipleExample multipleExample = new OpMemberLabelBasicMultipleExample();
            multipleExample.createCriteria().andLabelBasicIdEqualTo(basic.getId());
            List multipleList = this.opMemberLabelBasicMultipleMapper.selectByExample(multipleExample);
            if (CollectionUtils.isNotEmpty((Collection)multipleList)) {
                ArrayList<OpMemberLabelBasicMultipleVO> multipleVOList = new ArrayList<OpMemberLabelBasicMultipleVO>(multipleList.size());
                ArrayList<String> selectAccessWay = new ArrayList<String>();
                ArrayList<String> selectChannel = new ArrayList<String>();
                ArrayList<String> selectProvince = new ArrayList<String>();
                ArrayList<String> selectMemberLevel = new ArrayList<String>();
                ArrayList<String> selectGender = new ArrayList<String>();
                ArrayList<String> selectRFM = new ArrayList<String>();
                for (OpMemberLabelBasicMultiple multiple : multipleList) {
                    multipleVO = new OpMemberLabelBasicMultipleVO();
                    BeanUtils.copyProperties((Object)multipleVO, (Object)multiple);
                    multipleVOList.add(multipleVO);
                    if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.ACCESS_WAY.getCode())) {
                        selectAccessWay.add(multiple.getMultipleValue());
                        continue;
                    }
                    if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.CHANNEL.getCode())) {
                        selectChannel.add(multiple.getMultipleValue());
                        continue;
                    }
                    if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.PROVINCE.getCode())) {
                        selectProvince.add(multiple.getMultipleValue());
                        continue;
                    }
                    if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.MEMBER_LEVEL.getCode())) {
                        selectMemberLevel.add(multiple.getMultipleValue());
                        continue;
                    }
                    if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.GENDER.getCode())) {
                        selectGender.add(multiple.getMultipleValue());
                        continue;
                    }
                    if (!multiple.getMultipleType().equals(BasicMultipleTypeEnum.RFM.getCode())) continue;
                    selectRFM.add(multiple.getMultipleValue());
                }
                basicVO.setMultipleList(multipleVOList);
                basicVO.setSelectAccessWay(selectAccessWay);
                basicVO.setSelectGender(selectGender);
                basicVO.setSelectChannel(selectChannel);
                basicVO.setSelectMemberLevel(selectMemberLevel);
                basicVO.setSelectProvince(selectProvince);
                basicVO.setSelectRFM(selectRFM);
            }
            labelVO.setBasic(basicVO);
        }
        OpMemberLabelBehaviourExample behaviourExample = new OpMemberLabelBehaviourExample();
        behaviourExample.createCriteria().andLabelIdEqualTo(labelId);
        List behaviourList = this.opMemberLabelBehaviourMapper.selectByExample(behaviourExample);
        if (CollectionUtils.isNotEmpty((Collection)behaviourList)) {
            ArrayList<OpMemberLabelBehaviourVO> behaviourVOList = new ArrayList<OpMemberLabelBehaviourVO>(behaviourList.size());
            ArrayList<Integer> behaviourIdList = new ArrayList<Integer>(behaviourList.size());
            for (OpMemberLabelBehaviour behaviour : behaviourList) {
                OpMemberLabelBehaviourVO behaviourVO = new OpMemberLabelBehaviourVO();
                BeanUtils.copyProperties((Object)behaviourVO, (Object)behaviour);
                behaviourVOList.add(behaviourVO);
                behaviourIdList.add(behaviour.getId());
            }
            OpMemberLabelBehaviourMultipleExample channelExample = new OpMemberLabelBehaviourMultipleExample();
            channelExample.createCriteria().andLabelBehaviourIdIn(behaviourIdList);
            List multipleList = this.opMemberLabelBehaviourMultipleMapper.selectByExample(channelExample);
            if (CollectionUtils.isNotEmpty((Collection)multipleList)) {
                HashMap behaviour_channel = new HashMap();
                for (OpMemberLabelBehaviourMultiple multiple : multipleList) {
                    Integer behaviourId = multiple.getLabelBehaviourId();
                    ArrayList<OpMemberLabelBehaviourMultipleVO> channelVOList = (ArrayList<OpMemberLabelBehaviourMultipleVO>)behaviour_channel.get(behaviourId);
                    if (CollectionUtils.isEmpty((Collection)channelVOList)) {
                        channelVOList = new ArrayList<OpMemberLabelBehaviourMultipleVO>(multipleList.size());
                    }
                    OpMemberLabelBehaviourMultipleVO multipleVO2 = new OpMemberLabelBehaviourMultipleVO();
                    BeanUtils.copyProperties((Object)multipleVO2, (Object)multiple);
                    channelVOList.add(multipleVO2);
                    behaviour_channel.put(behaviourId, channelVOList);
                }
                for (OpMemberLabelBehaviourVO vo : behaviourVOList) {
                    List multipleVOList = (List)behaviour_channel.get(vo.getId());
                    if (!CollectionUtils.isNotEmpty((Collection)multipleVOList)) continue;
                    vo.setMultipleList(multipleVOList);
                    ArrayList<String> selectChannel = new ArrayList<String>();
                    ArrayList<String> selectAccessWay = new ArrayList<String>();
                    for (OpMemberLabelBehaviourMultipleVO mu : multipleVOList) {
                        if (mu.getMultipleType() == 0) {
                            selectAccessWay.add(mu.getMultipleValue());
                            continue;
                        }
                        if (mu.getMultipleType() != 1) continue;
                        selectChannel.add(mu.getMultipleValue());
                    }
                    vo.setSelectChannel(selectChannel);
                    vo.setSelectAccessWay(selectAccessWay);
                }
            }
            labelVO.setBehaviour(behaviourVOList);
        }
        OpMemberLabelConsumeExample consumeExample = new OpMemberLabelConsumeExample();
        consumeExample.createCriteria().andLabelIdEqualTo(labelId);
        List consumeList = this.opMemberLabelConsumeMapper.selectByExample(consumeExample);
        if (CollectionUtils.isNotEmpty((Collection)consumeList)) {
            ArrayList<OpMemberLabelConsumeVO> consumeVOList = new ArrayList<OpMemberLabelConsumeVO>(consumeList.size());
            ArrayList<Integer> consumeIdList = new ArrayList<Integer>(consumeList.size());
            for (OpMemberLabelConsume consume : consumeList) {
                OpMemberLabelConsumeVO consumeVO = new OpMemberLabelConsumeVO();
                BeanUtils.copyProperties((Object)consumeVO, (Object)consume);
                consumeVOList.add(consumeVO);
                consumeIdList.add(consume.getId());
            }
            OpMemberLabelConsumeMultipleExample multipleExample = new OpMemberLabelConsumeMultipleExample();
            multipleExample.createCriteria().andLabelConsumeIdIn(consumeIdList);
            List multipleList = this.opMemberLabelConsumeMultipleMapper.selectByExample(multipleExample);
            if (CollectionUtils.isNotEmpty((Collection)multipleList)) {
                HashMap consume_multiple = new HashMap();
                for (OpMemberLabelConsumeMultiple multiple : multipleList) {
                    Integer consumeId = multiple.getLabelConsumeId();
                    ArrayList<OpMemberLabelBasicMultipleVO> multipleVOList = (ArrayList<OpMemberLabelBasicMultipleVO>)consume_multiple.get(consumeId);
                    if (CollectionUtils.isEmpty((Collection)multipleVOList)) {
                        multipleVOList = new ArrayList<OpMemberLabelBasicMultipleVO>(multipleList.size());
                    }
                    multipleVO = new OpMemberLabelConsumeMultipleVO();
                    BeanUtils.copyProperties((Object)multipleVO, (Object)multiple);
                    multipleVOList.add(multipleVO);
                    consume_multiple.put(consumeId, multipleVOList);
                }
                for (OpMemberLabelConsumeVO vo : consumeVOList) {
                    List multipleVOList = (List)consume_multiple.get(vo.getId());
                    if (!CollectionUtils.isNotEmpty((Collection)multipleVOList)) continue;
                    vo.setMultipleList(multipleVOList);
                    ArrayList<String> selectChannel = new ArrayList<String>();
                    ArrayList<String> selectAccessWay = new ArrayList<String>();
                    String selectCategory = "";
                    for (OpMemberLabelConsumeMultipleVO mu : multipleVOList) {
                        if (mu.getMultipleType() == 0) {
                            selectAccessWay.add(mu.getMultipleValue());
                            continue;
                        }
                        if (mu.getMultipleType() == 1) {
                            selectChannel.add(mu.getMultipleValue());
                            continue;
                        }
                        if (mu.getMultipleType() != 2) continue;
                        selectCategory = selectCategory + mu.getMultipleValue() + ",";
                    }
                    vo.setSelectChannel(selectChannel);
                    vo.setSelectCategory(selectCategory);
                    vo.setSelectAccessWay(selectAccessWay);
                }
            }
            labelVO.setConsume(consumeVOList);
        }
        return labelVO;
    }

    public List<OpMemberLabelVO> selectAllMemberLabel(OpMemberLabelQueryDTO dto) {
        ArrayList<OpMemberLabelVO> returnList = new ArrayList();
        OpMemberLabelExample example = new OpMemberLabelExample();
        OpMemberLabelExample.Criteria criteria = example.createCriteria();
        this.criteriaDTO(criteria, dto);
        List labelList = this.opMemberLabelMapper.selectByExample(example);
        returnList = this.beanConverter.converterListFrom(labelList, OpMemberLabelVO.class);
        return returnList;
    }

    private void insertLabelSQL(Integer LabelId, List<OpMemberLabelQuerysql> sqlList) {
        OpMemberLabelQuerysqlExample example = new OpMemberLabelQuerysqlExample();
        example.createCriteria().andLabelIdEqualTo(LabelId);
        this.opMemberLabelQuerysqlMapper.deleteByExample(example);
        if (CollectionUtils.isNotEmpty(sqlList)) {
            for (OpMemberLabelQuerysql sql : sqlList) {
                this.opMemberLabelQuerysqlMapper.insertSelective(sql);
            }
        }
    }

    private List<OpMemberLabelQuerysql> getInsertLabelSQL(OpMemberLabelVO labelVO) {
        ArrayList<OpMemberLabelQuerysql> insertSqlList = new ArrayList<OpMemberLabelQuerysql>();
        if (labelVO != null) {
            Integer labelId = labelVO.getId();
            if (labelVO.getBasic() != null) {
                String dateEnd;
                String dateStart;
                StringBuffer basicsb = new StringBuffer("-- \u57fa\u672c\u5c5e\u6027\u6761\u4ef6\u67e5\u8be2");
                basicsb.append("\r\n");
                basicsb.append("select member_code from dm.api_data_crm_member where 1=1 ");
                OpMemberLabelBasicVO basic = labelVO.getBasic();
                if (basic.getRegistrationDateType() != null && basic.getRegistrationDateType() > 0) {
                    dateStart = "";
                    dateEnd = "";
                    if (basic.getRegistrationDateType() == 1) {
                        if (basic.getRegistrationTodayStart() != null && basic.getRegistrationTodayStart() > 0) {
                            dateEnd = this.getDateStr(-basic.getRegistrationTodayStart().intValue(), 2);
                        }
                        if (basic.getRegistrationTodayEnd() != null && basic.getRegistrationTodayEnd() > 0) {
                            dateStart = this.getDateStr(-basic.getRegistrationTodayEnd().intValue(), 1);
                        }
                    } else if (basic.getRegistrationDateType() == 2) {
                        if (basic.getRegistrationDateStart() != null) {
                            dateStart = DateUtil.formatDate((Date)basic.getRegistrationDateStart(), (String)"yyyy-MM-dd");
                        }
                        if (basic.getRegistrationDateEnd() != null) {
                            dateEnd = DateUtil.formatDate((Date)DateUtil.addDate((Date)basic.getRegistrationDateEnd(), (int)1), (String)"yyyy-MM-dd");
                        }
                    }
                    if (!StringUtils.isEmpty((String)dateStart)) {
                        basicsb.append(" and register_time >= '" + dateStart + "'");
                    }
                    if (!StringUtils.isEmpty((String)dateEnd)) {
                        basicsb.append(" and register_time < '" + dateEnd + "'");
                    }
                }
                if (basic.getBirthdayType() != null && basic.getBirthdayType() > 0) {
                    dateStart = "";
                    dateEnd = "";
                    if (basic.getBirthdayType() == 1) {
                        if (basic.getBirthdayTodayStart() != null && basic.getBirthdayTodayStart() > 0) {
                            dateEnd = this.getDateStr(-basic.getBirthdayTodayStart().intValue(), 2);
                        }
                        if (basic.getRegistrationTodayEnd() != null && basic.getRegistrationTodayEnd() > 0) {
                            dateStart = this.getDateStr(-basic.getRegistrationTodayEnd().intValue(), 1);
                        }
                    } else if (basic.getBirthdayType() == 2) {
                        if (basic.getBirthdayDateStart() != null) {
                            dateStart = DateUtil.formatDate((Date)basic.getBirthdayDateStart(), (String)"yyyy-MM-dd");
                        }
                        if (basic.getBirthdayDateEnd() != null) {
                            dateEnd = DateUtil.formatDate((Date)DateUtil.addDate((Date)basic.getBirthdayDateEnd(), (int)1), (String)"yyyy-MM-dd");
                        }
                    }
                    if (!StringUtils.isEmpty((String)dateStart)) {
                        dateStart = dateStart.substring(5);
                        dateStart = dateStart.replace("-", "");
                        basicsb.append(" and to_char(birthday,'MMDD') >= '" + dateStart + "'");
                    }
                    if (!StringUtils.isEmpty((String)dateEnd)) {
                        dateEnd = dateEnd.substring(5);
                        dateEnd = dateEnd.replace("-", "");
                        basicsb.append(" and to_char(birthday,'MMDD') < '" + dateEnd + "'");
                    }
                }
                if (basic.getLevelExpireType() != null && basic.getLevelExpireType() > 0) {
                    dateStart = "";
                    dateEnd = "";
                    if (basic.getLevelExpireType() == 1) {
                        if (basic.getLevelTodayStart() != null && basic.getLevelTodayStart() > 0) {
                            dateEnd = this.getDateStr(-basic.getLevelTodayStart().intValue(), 2);
                        }
                        if (basic.getLevelTodayEnd() != null && basic.getLevelTodayEnd() > 0) {
                            dateStart = this.getDateStr(-basic.getLevelTodayEnd().intValue(), 1);
                        }
                    } else if (basic.getLevelExpireType() == 2) {
                        if (basic.getLevelDateStart() != null) {
                            dateStart = DateUtil.formatDate((Date)basic.getLevelDateStart(), (String)"yyyy-MM-dd");
                        }
                        if (basic.getLevelDateEnd() != null) {
                            dateEnd = DateUtil.formatDate((Date)DateUtil.addDate((Date)basic.getLevelDateEnd(), (int)1), (String)"yyyy-MM-dd");
                        }
                    }
                    if (!StringUtils.isEmpty((String)dateStart)) {
                        basicsb.append(" and level_expire_time >= '" + dateStart + "'");
                    }
                    if (!StringUtils.isEmpty((String)dateEnd)) {
                        basicsb.append(" and level_expire_time < '" + dateEnd + "'");
                    }
                }
                if (basic.getAgeStart() != null && basic.getAgeEnd() != null && basic.getAgeStart() == basic.getAgeEnd()) {
                    basicsb.append(" and age = '" + basic.getAgeStart() + "'");
                } else {
                    if (basic.getAgeStart() != null) {
                        basicsb.append(" and age >= " + basic.getAgeStart());
                    }
                    if (basic.getAgeEnd() != null) {
                        basicsb.append(" and age <= " + basic.getAgeEnd());
                    }
                }
                if (basic.getTotalConsumptionStart() != null && basic.getTotalConsumptionEnd() != null && basic.getTotalConsumptionStart().compareTo(basic.getTotalConsumptionEnd()) == 0) {
                    basicsb.append(" and all_point = '" + basic.getTotalConsumptionStart() + "'");
                } else {
                    if (basic.getTotalConsumptionStart() != null) {
                        basicsb.append(" and all_point >= " + basic.getTotalConsumptionStart());
                    }
                    if (basic.getTotalConsumptionEnd() != null) {
                        basicsb.append(" and all_point <= " + basic.getTotalConsumptionEnd());
                    }
                }
                if (basic.getEffectiveConsumptionStart() != null && basic.getEffectiveConsumptionEnd() != null && basic.getEffectiveConsumptionStart().compareTo(basic.getEffectiveConsumptionEnd()) == 0) {
                    basicsb.append(" and effective_point = '" + basic.getEffectiveConsumptionStart() + "'");
                } else {
                    if (basic.getEffectiveConsumptionStart() != null) {
                        basicsb.append(" and effective_point >= " + basic.getEffectiveConsumptionStart());
                    }
                    if (basic.getEffectiveConsumptionEnd() != null) {
                        basicsb.append(" and effective_point <= " + basic.getEffectiveConsumptionEnd());
                    }
                }
                if (basic.getAvailablePointStart() != null && basic.getAvailablePointEnd() != null && basic.getAvailablePointStart() == basic.getAvailablePointEnd()) {
                    basicsb.append(" and valid_point = '" + basic.getAvailablePointStart() + "'");
                } else {
                    if (basic.getAvailablePointStart() != null) {
                        basicsb.append(" and valid_point >= " + basic.getAvailablePointStart());
                    }
                    if (basic.getAvailablePointEnd() != null) {
                        basicsb.append(" and valid_point <= " + basic.getAvailablePointEnd());
                    }
                }
                List mulitpleList = basic.getMultipleList();
                if (CollectionUtils.isNotEmpty((Collection)mulitpleList)) {
                    String selectAccessWay = "";
                    String selectChannel = "";
                    String selectProvince = "";
                    String selectMemberLevel = "";
                    String selectGender = "";
                    String selectRFM = "";
                    for (OpMemberLabelConsumeMultipleVO multiple : mulitpleList) {
                        if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.ACCESS_WAY.getCode())) {
                            selectAccessWay = selectAccessWay + "," + multiple.getMultipleValue();
                            continue;
                        }
                        if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.CHANNEL.getCode())) {
                            selectChannel = selectChannel + "," + "'" + multiple.getMultipleValue() + "'";
                            continue;
                        }
                        if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.PROVINCE.getCode())) {
                            selectProvince = selectProvince + "," + multiple.getMultipleValue();
                            continue;
                        }
                        if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.MEMBER_LEVEL.getCode())) {
                            selectMemberLevel = selectMemberLevel + "," + "'" + multiple.getMultipleValue() + "'";
                            continue;
                        }
                        if (multiple.getMultipleType().equals(BasicMultipleTypeEnum.GENDER.getCode())) {
                            selectGender = selectGender + "," + "'" + multiple.getMultipleValue() + "'";
                            continue;
                        }
                        if (!multiple.getMultipleType().equals(BasicMultipleTypeEnum.RFM.getCode())) continue;
                        selectRFM = selectRFM + "," + "'" + multiple.getMultipleValue() + "'";
                    }
                    if (!StringUtil.isEmpty((String)selectAccessWay)) {
                        selectAccessWay = selectAccessWay.substring(1);
                        basicsb.append(" and access_way in(" + selectAccessWay + ")");
                    }
                    if (!StringUtil.isEmpty((String)selectChannel)) {
                        selectChannel = selectChannel.substring(1);
                        basicsb.append(" and channel_code not in(" + selectChannel + ")");
                    }
                    if (!StringUtil.isEmpty((String)selectProvince)) {
                        selectProvince = selectProvince.substring(1);
                        basicsb.append(" and address_region in(" + selectProvince + ")");
                    }
                    if (!StringUtil.isEmpty((String)selectMemberLevel)) {
                        selectMemberLevel = selectMemberLevel.substring(1);
                        basicsb.append(" and member_level in(" + selectMemberLevel + ")");
                    }
                    if (!StringUtil.isEmpty((String)selectGender)) {
                        selectGender = selectGender.substring(1);
                        basicsb.append(" and sex in(" + selectGender + ")");
                    }
                    if (!StringUtil.isEmpty((String)selectRFM)) {
                        selectRFM = selectRFM.substring(1);
                        basicsb.append(" and rfm_label in(" + selectRFM + ")");
                    }
                }
                OpMemberLabelQuerysql sql = new OpMemberLabelQuerysql();
                sql.setLabelId(basic.getLabelId());
                sql.setType(Integer.valueOf(1));
                sql.setQuerySql(basicsb.toString());
                insertSqlList.add(sql);
            }
            if (CollectionUtils.isNotEmpty((Collection)labelVO.getBehaviour())) {
                List behaviourList = labelVO.getBehaviour();
                for (OpMemberLabelBehaviourVO behaviour : behaviourList) {
                    Integer behaviourType = behaviour.getBehaviourType();
                    StringBuffer behavioursb = new StringBuffer("");
                    StringBuffer channelsb = new StringBuffer("");
                    OpMemberLabelQuerysql sql = new OpMemberLabelQuerysql();
                    String selectAccessWay = "";
                    String selectChannel = "";
                    List multipleList = behaviour.getMultipleList();
                    if (CollectionUtils.isNotEmpty((Collection)multipleList)) {
                        for (OpMemberLabelBehaviourMultipleVO multiple : multipleList) {
                            if (multiple.getMultipleType() == 0) {
                                selectAccessWay = selectAccessWay + "," + multiple.getMultipleValue();
                                continue;
                            }
                            if (multiple.getMultipleType() != 1) continue;
                            selectChannel = selectChannel + "," + "'" + multiple.getMultipleValue() + "'";
                        }
                    }
                    if (!StringUtils.isEmpty((String)selectAccessWay)) {
                        selectAccessWay = selectAccessWay.substring(1);
                        channelsb.append(" and access_way in(" + selectAccessWay + ")");
                    }
                    if (!StringUtils.isEmpty((String)selectChannel)) {
                        selectChannel = selectChannel.substring(1);
                        channelsb.append(" and channel_code not in(" + selectChannel + ")");
                    }
                    if (behaviour.getLoginDateType() != null && behaviour.getLoginDateType() > 0) {
                        String dateStart = "";
                        String dateEnd = "";
                        behavioursb = new StringBuffer("");
                        behavioursb.append("-- \u884c\u4e3a\u6570\u636e -> \u767b\u9646\u6761\u4ef6\u67e5\u8be2");
                        behavioursb.append("\r\n");
                        behavioursb.append("select member_code from dm.api_data_crm_login where 1=1 ");
                        StringBuffer selectsb = new StringBuffer();
                        selectsb.append(channelsb);
                        if (behaviour.getLoginDateType() == 1) {
                            if (behaviour.getLoginTodayStart() != null && behaviour.getLoginTodayStart() > 0) {
                                dateEnd = this.getDateStr(-behaviour.getLoginTodayStart().intValue(), 2);
                            }
                            if (behaviour.getLoginTodayEnd() != null && behaviour.getLoginTodayEnd() > 0) {
                                dateStart = this.getDateStr(-behaviour.getLoginTodayEnd().intValue(), 1);
                            }
                        } else if (behaviour.getLoginDateType() == 2) {
                            if (behaviour.getLoginDateStart() != null) {
                                dateStart = DateUtil.formatDate((Date)behaviour.getLoginDateStart(), (String)"yyyy-MM-dd");
                            }
                            if (behaviour.getLoginDateEnd() != null) {
                                dateEnd = DateUtil.formatDate((Date)DateUtil.addDate((Date)behaviour.getLoginDateEnd(), (int)1), (String)"yyyy-MM-dd");
                            }
                        }
                        if (!StringUtils.isEmpty((String)dateStart)) {
                            selectsb.append(" and login_time >= '" + dateStart + "'");
                        }
                        if (!StringUtils.isEmpty((String)dateEnd)) {
                            selectsb.append(" and login_time < '" + dateEnd + "'");
                        }
                        if (behaviour.getLoginType() != null) {
                            if (behaviour.getLoginType() == 2) {
                                behavioursb = new StringBuffer("");
                                behavioursb.append("-- \u884c\u4e3a\u6570\u636e -> \u672a\u767b\u9646\u6761\u4ef6\u67e5\u8be2");
                                behavioursb.append("\r\n");
                                behavioursb.append("SELECT a.member_code from dm.api_data_crm_member a");
                                behavioursb.append(" where NOT EXISTS( select 1 from dm.api_data_crm_login  where 1=1 and member_code = a.member_code");
                                behavioursb.append(selectsb);
                                behavioursb.append(")");
                            } else {
                                if (behaviour.getLoginType() == 1) {
                                    selectsb.append(" and is_first = 'Y' ");
                                } else if (behaviour.getLoginType() == 3) {
                                    selectsb.append(" and is_last = 'Y' ");
                                }
                                behavioursb.append(selectsb);
                            }
                            sql = new OpMemberLabelQuerysql();
                            sql.setLabelId(labelId);
                            sql.setType(behaviourType);
                            sql.setQuerySql(behavioursb.toString());
                            insertSqlList.add(sql);
                        }
                    }
                    if (behaviour.getOrderDateType() == null || behaviour.getOrderDateType() <= 0) continue;
                    behavioursb = new StringBuffer("");
                    behavioursb.append("-- \u884c\u4e3a\u6570\u636e -> \u4e0b\u5355\u6761\u4ef6\u67e5\u8be2");
                    behavioursb.append("\r\n");
                    behavioursb.append("select member_code from dm.api_data_crm_order where 1=1 ");
                    StringBuffer selectsb = new StringBuffer();
                    selectsb.append(channelsb);
                    String dateStart = "";
                    String dateEnd = "";
                    if (behaviour.getOrderDateType() == 1) {
                        if (behaviour.getOrderTodayStart() != null && behaviour.getOrderTodayStart() > 0) {
                            dateEnd = this.getDateStr(-behaviour.getOrderTodayStart().intValue(), 2);
                        }
                        if (behaviour.getOrderTodayEnd() != null && behaviour.getOrderTodayEnd() > 0) {
                            dateStart = this.getDateStr(-behaviour.getOrderTodayEnd().intValue(), 1);
                        }
                    } else if (behaviour.getOrderDateType() == 2) {
                        if (behaviour.getOrderDateStart() != null) {
                            dateStart = DateUtil.formatDate((Date)behaviour.getOrderDateStart(), (String)"yyyy-MM-dd");
                        }
                        if (behaviour.getOrderDateEnd() != null) {
                            dateEnd = DateUtil.formatDate((Date)DateUtil.addDate((Date)behaviour.getOrderDateEnd(), (int)1), (String)"yyyy-MM-dd");
                        }
                    }
                    if (!StringUtils.isEmpty((String)dateStart)) {
                        selectsb.append(" and pay_time >= '" + dateStart + "'");
                    }
                    if (!StringUtils.isEmpty((String)dateEnd)) {
                        selectsb.append(" and pay_time < '" + dateEnd + "'");
                    }
                    if (behaviour.getOrderType() != null) {
                        if (behaviour.getOrderType() == 2) {
                            behavioursb = new StringBuffer("");
                            behavioursb.append("-- \u884c\u4e3a\u6570\u636e -> \u672a\u4e0b\u5355\u6761\u4ef6\u67e5\u8be2");
                            behavioursb.append("\r\n");
                            behavioursb.append("SELECT a.member_code from dm.api_data_crm_member a");
                            behavioursb.append(" where NOT EXISTS( select 1 from dm.api_data_crm_order  where 1=1 and member_code = a.member_code");
                            behavioursb.append(selectsb);
                            behavioursb.append(")");
                        } else {
                            if (behaviour.getOrderType() == 1) {
                                selectsb.append(" and is_first = 'Y' ");
                            } else if (behaviour.getOrderType() == 3) {
                                selectsb.append(" and is_last = 'Y' ");
                            }
                            behavioursb.append(selectsb);
                        }
                    }
                    sql = new OpMemberLabelQuerysql();
                    sql.setLabelId(labelId);
                    sql.setType(behaviourType);
                    sql.setQuerySql(behavioursb.toString());
                    insertSqlList.add(sql);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)labelVO.getConsume())) {
                List consumeList = labelVO.getConsume();
                for (OpMemberLabelConsumeVO consume : consumeList) {
                    StringBuffer consumesb = new StringBuffer("");
                    StringBuffer sb = new StringBuffer();
                    String selectAccessWay = "";
                    String selectChannel = "";
                    String selectCategory = "";
                    List multipleList = consume.getMultipleList();
                    if (CollectionUtils.isNotEmpty((Collection)multipleList)) {
                        for (OpMemberLabelConsumeMultipleVO multiple : multipleList) {
                            if (multiple.getMultipleType() == 0) {
                                selectAccessWay = selectAccessWay + "," + multiple.getMultipleValue();
                                continue;
                            }
                            if (multiple.getMultipleType() == 1) {
                                selectChannel = selectChannel + "," + "'" + multiple.getMultipleValue() + "'";
                                continue;
                            }
                            if (multiple.getMultipleType() != 2) continue;
                            selectCategory = selectCategory + "," + multiple.getMultipleValue();
                        }
                    }
                    if (consume.getConsumeDateType() != null && consume.getConsumeDateType() > 0) {
                        String dateStart = "";
                        String dateEnd = "";
                        if (consume.getConsumeDateType() == 1) {
                            if (consume.getConsumeTodayStart() != null && consume.getConsumeTodayStart() > 0) {
                                dateEnd = this.getDateStr(-consume.getConsumeTodayStart().intValue(), 2);
                            }
                            if (consume.getConsumeTodayEnd() != null && consume.getConsumeTodayEnd() > 0) {
                                dateStart = this.getDateStr(-consume.getConsumeTodayEnd().intValue(), 1);
                            }
                        } else if (consume.getConsumeDateType() == 2) {
                            if (consume.getConsumeDateStart() != null) {
                                dateStart = DateUtil.formatDate((Date)consume.getConsumeDateStart(), (String)"yyyy-MM-dd");
                            }
                            if (consume.getConsumeDateEnd() != null) {
                                dateEnd = DateUtil.formatDate((Date)DateUtil.addDate((Date)consume.getConsumeDateEnd(), (int)1), (String)"yyyy-MM-dd");
                            }
                        }
                        if (!StringUtils.isEmpty((String)dateStart)) {
                            sb.append(" and pay_time >= '" + dateStart + "'");
                        }
                        if (!StringUtils.isEmpty((String)dateEnd)) {
                            sb.append(" and pay_time < '" + dateEnd + "'");
                        }
                    }
                    if (!StringUtils.isEmpty((String)selectAccessWay)) {
                        selectAccessWay = selectAccessWay.substring(1);
                        sb.append(" and access_way in(" + selectAccessWay + ")");
                    }
                    if (!StringUtils.isEmpty((String)selectChannel)) {
                        selectChannel = selectChannel.substring(1);
                        sb.append(" and channel_code not in(" + selectChannel + ")");
                    }
                    if (!StringUtils.isEmpty((String)selectCategory)) {
                        selectCategory = selectCategory.substring(1);
                        sb.append(" and categray_id in(" + selectCategory + ")");
                    }
                    if (consume.getConsumeTotalStart() != null || consume.getConsumeTotalEnd() != null) {
                        Integer totalType = consume.getConsumeTotalType();
                        String str = "";
                        String havingString = "";
                        if (totalType == 1) {
                            str = " amount ";
                        } else if (totalType == 2) {
                            str = " sum(amount)/COUNT(so_order_code) ";
                        } else if (totalType == 3) {
                            str = " sum(amount) ";
                        } else if (totalType == 4) {
                            str = " count(so_order_code) ";
                        }
                        if (consume.getConsumeTotalStart() != null && consume.getConsumeTotalEnd() != null) {
                            havingString = "having " + str + ">=" + consume.getConsumeTotalStart() + " and " + str + "<=" + consume.getConsumeTotalEnd();
                        } else if (consume.getConsumeTotalStart() != null) {
                            havingString = "having " + str + ">=" + consume.getConsumeTotalStart();
                        } else if (consume.getConsumeTotalEnd() != null) {
                            havingString = "having " + str + "<=" + consume.getConsumeTotalEnd();
                        }
                        consumesb.append("-- \u6d88\u8d39\u4e60\u60ef\u6761\u4ef6\u67e5\u8be2  -->\u6709\u6d88\u8d39\u7edf\u8ba1");
                        consumesb.append("\r\n");
                        consumesb.append("select member_code from");
                        consumesb.append("( select " + str + " , member_code  from dm.api_data_crm_order where 1=1");
                        consumesb.append(sb);
                        consumesb.append(" group by member_code ");
                        if (totalType == 1) {
                            consumesb.append(",amount ");
                        }
                        consumesb.append(havingString + ")aa");
                    } else {
                        consumesb.append("-- \u6d88\u8d39\u4e60\u60ef\u6761\u4ef6\u67e5\u8be2 -->\u65e0\u6d88\u8d39\u7edf\u8ba1");
                        consumesb.append("\r\n");
                        consumesb.append("select member_code from dm.api_data_crm_order where 1=1");
                        consumesb.append(sb);
                    }
                    OpMemberLabelQuerysql sql = new OpMemberLabelQuerysql();
                    sql.setLabelId(labelId);
                    sql.setType(consume.getConsumeType());
                    sql.setQuerySql(consumesb.toString());
                    insertSqlList.add(sql);
                }
            }
        }
        return insertSqlList;
    }

    private String getDateStr(Integer day, Integer type) {
        Date date = new Date();
        String str = "";
        if (day < 0) {
            if (type == 2) {
                day = day + 1;
            }
            str = DateUtil.formatDate((Date)DateUtil.addDate((Date)date, (int)day), (String)"yyyy-MM-dd");
        }
        return str;
    }

    public PageQueryResp<OpCrmMemberVO> queryMemberVOPageByDto(OpMemberLabelQueryDTO dto) {
        PageQueryResp page = new PageQueryResp();
        List<String> memberCodeList = dto.getMemberCodeList();
        if (CollectionUtils.isEmpty((Collection)memberCodeList)) {
            memberCodeList = this.queryMemberCodeListByDto(dto);
        }
        if (CollectionUtils.isNotEmpty((Collection)memberCodeList)) {
            OpCrmMemberExample example = new OpCrmMemberExample();
            example.createCriteria().andMemberCodeIn(memberCodeList);
            int count = memberCodeList.size();
            if (dto.getPagenum() > 0) {
                example.setCriteriaStr(dto.getBiCriteriaStr());
            }
            List memberList = this.opCrmMemberMapper.selectByExample(example);
            List resultList = this.beanConverter.converterListFrom(memberList, OpCrmMemberVO.class);
            page.setBeanList(resultList);
            page.setPageSize(dto.getPagenum());
            page.setPageNo(dto.getCurrpage());
            page.setTotalCnt(Integer.valueOf(count));
        }
        return page;
    }

    public List<String> queryMemberCodeListByDto(OpMemberLabelQueryDTO dto) {
        int i;
        OpMemberLabelVO labelVO = new OpMemberLabelVO();
        labelVO.setBasic(dto.getBasic());
        labelVO.setBehaviour(dto.getBehaviour());
        labelVO.setConsume(dto.getConsume());
        List<OpMemberLabelQuerysql> sqlList = this.getInsertLabelSQL(labelVO);
        StringBuffer sb = new StringBuffer("");
        if (CollectionUtils.isNotEmpty((Collection)dto.getIdList())) {
            for (i = 0; i < dto.getIdList().size(); ++i) {
                Integer labelId = (Integer)dto.getIdList().get(i);
                if (StringUtils.isEmpty((String)this.getMemberByLabelSql(labelId, false))) continue;
                if (i > 0) {
                    sb.append(" UNION ");
                }
                sb.append("(" + this.getMemberByLabelSql(labelId, false) + ")");
            }
        }
        if (CollectionUtils.isNotEmpty(sqlList)) {
            for (i = 0; i < sqlList.size(); ++i) {
                OpMemberLabelQuerysql sql = sqlList.get(i);
                if (i > 0 || sb.length() > 0) {
                    sb.append(" INTERSECT ");
                }
                sb.append(sql.getQuerySql());
            }
        }
        List<String> memberCodeList = new ArrayList<String>();
        if (sb.length() > 0) {
            memberCodeList = this.opMemberLabelQuerysqlMapper.queryMemberQuerySql(sb.toString());
        }
        return memberCodeList;
    }

    public List<String> queryMemberByLabel(Integer labelId) {
        String str = this.getMemberByLabelSql(labelId, false);
        if (!StringUtils.isEmpty((String)str)) {
            return this.opMemberLabelQuerysqlMapper.queryMemberQuerySql(str);
        }
        return null;
    }

    public int countMemberByLabel(Integer labelId) {
        String str = this.getMemberByLabelSql(labelId, true);
        if (!StringUtils.isEmpty((String)str)) {
            return this.opMemberLabelQuerysqlMapper.countMemberQuerySql(str);
        }
        return 0;
    }

    private String getMemberByLabelSql(Integer labelId, Boolean isCount) {
        StringBuffer str = new StringBuffer("");
        OpMemberLabelQuerysqlExample example = new OpMemberLabelQuerysqlExample();
        example.createCriteria().andLabelIdEqualTo(labelId);
        example.setOrderByClause("type");
        List sqlList = this.opMemberLabelQuerysqlMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)sqlList)) {
            if (isCount.booleanValue()) {
                str.append("select count(aa.member_code) from (");
            }
            Boolean allFilter = true;
            for (OpMemberLabelQuerysql sql : sqlList) {
                if (sql.getType() != 1) continue;
                allFilter = false;
                break;
            }
            if (allFilter.booleanValue()) {
                str.append("select member_code from dm.api_data_crm_member where 1=1 ");
                for (OpMemberLabelQuerysql sql : sqlList) {
                    str.append(" EXCEPT ").append("\r\n").append(sql.getQuerySql());
                }
            } else {
                for (int i = 0; i < sqlList.size(); ++i) {
                    OpMemberLabelQuerysql sql;
                    sql = (OpMemberLabelQuerysql)sqlList.get(i);
                    if (i > 0) {
                        if (sql.getType() == 1) {
                            str.append(" INTERSECT ");
                        } else {
                            str.append(" EXCEPT ");
                        }
                    }
                    str.append("\r\n").append(sql.getQuerySql());
                }
            }
            if (isCount.booleanValue()) {
                str.append(")aa");
            }
            return str.toString();
        }
        return "";
    }

    public OpMemberLabelEffectiveVO queryMemberLabelEffectiveness(OpMemberLabelEffectiveDTO dto) {
        OpMemberLabelEffectiveVO vo = new OpMemberLabelEffectiveVO();
        Integer memberCount = 0;
        Integer visitCount = 0;
        Integer shoppingCount = 0;
        Integer orderCount = 0;
        Integer orderQuantity = 0;
        BigDecimal orderAmount = BigDecimal.ZERO;
        BigDecimal orderAverageAmount = BigDecimal.ZERO;
        List<String> memberCodeList = this.queryMemberByLabel(dto.getLabelId());
        if (CollectionUtils.isNotEmpty(memberCodeList)) {
            Map result;
            StringBuffer memberCodeStr = new StringBuffer("");
            for (int i = 0; i < memberCodeList.size(); ++i) {
                if (i > 0) {
                    memberCodeStr.append(",");
                }
                memberCodeStr.append("'" + memberCodeList.get(i) + "'");
            }
            memberCount = memberCodeList.size();
            String dateStart = "";
            String dateEnd = "";
            if (dto.getDateStart() != null || dto.getDateEnd() != null) {
                if (dto.getDateStart() != null) {
                    dateStart = DateUtil.formatDate((Date)dto.getDateStart(), (String)"yyyy-MM-dd");
                }
                if (dto.getDateEnd() != null) {
                    dateEnd = DateUtil.formatDate((Date)DateUtil.addDate((Date)dto.getDateStart(), (int)1), (String)"yyyy-MM-dd");
                }
            } else if (dto.getTodayStart() != null || dto.getTodayEnd() != null) {
                if (dto.getTodayStart() != null) {
                    dateEnd = this.getDateStr(-dto.getTodayStart().intValue(), 2);
                }
                if (dto.getTodayEnd() != null) {
                    dateStart = this.getDateStr(-dto.getTodayEnd().intValue(), 1);
                }
            }
            StringBuffer sb = new StringBuffer("");
            sb.append("SELECT COUNT(DISTINCT member_code) FROM dm.api_data_crm_login");
            sb.append(" where 1=1");
            sb.append(" and member_code IN(" + memberCodeStr + ")");
            if (!StringUtils.isEmpty((String)dateStart)) {
                sb.append(" and login_time >= '" + dateStart + "'");
            }
            if (!StringUtils.isEmpty((String)dateEnd)) {
                sb.append(" and login_time < '" + dateEnd + "'");
            }
            visitCount = this.opMemberLabelQuerysqlMapper.countMemberQuerySql(sb.toString());
            sb = new StringBuffer("");
            sb.append("SELECT COUNT(DISTINCT member_code) FROM dm.api_data_crm_cart");
            sb.append(" where 1=1");
            sb.append(" and member_code IN(" + memberCodeStr + ")");
            if (!StringUtils.isEmpty((String)dateStart)) {
                sb.append(" and add_time >= '" + dateStart + "'");
            }
            if (!StringUtils.isEmpty((String)dateEnd)) {
                sb.append(" and add_time < '" + dateEnd + "'");
            }
            shoppingCount = this.opMemberLabelQuerysqlMapper.countMemberQuerySql(sb.toString());
            sb = new StringBuffer("SELECT COUNT(DISTINCT member_code) orderCount,SUM(amount) orderAmount,COUNT(DISTINCT so_order_code) orderQuantity FROM dm.api_data_crm_order");
            sb.append(" where 1=1 ");
            sb.append(" and member_code IN(" + memberCodeStr + ")");
            if (!StringUtils.isEmpty((String)dateStart)) {
                sb.append(" and pay_time >= '" + dateStart + "'");
            }
            if (!StringUtils.isEmpty((String)dateEnd)) {
                sb.append(" and pay_time < '" + dateEnd + "'");
            }
            if ((result = this.opMemberLabelQuerysqlMapper.queryMemberOrderEffectiveness(sb.toString())) != null && result.size() > 0) {
                if (result.get("orderCount") != null) {
                    orderCount = Integer.parseInt(result.get("orderCount").toString());
                }
                if (result.get("orderAmount") != null) {
                    orderAmount = new BigDecimal(result.get("orderAmount").toString());
                }
                if (result.get("orderQuantity") != null && (orderQuantity = Integer.valueOf(Integer.parseInt(result.get("orderQuantity").toString()))) > 0) {
                    orderAverageAmount = orderAmount.divide(new BigDecimal(orderQuantity), 2, 4);
                }
            }
        }
        vo.setMemberCount(memberCount);
        vo.setOrderAmount(orderAmount);
        vo.setOrderAverageAmount(orderAverageAmount);
        vo.setOrderCount(orderCount);
        vo.setOrderQuantity(orderQuantity);
        vo.setShoppingCount(shoppingCount);
        vo.setVisitCount(visitCount);
        return vo;
    }
}

