/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.utils;

import com.thebeastshop.bgel.runtime.BgelObject;
import com.thebeastshop.bgel.runtime.MethodParameterTypes;
import com.thebeastshop.bgel.runtime.wrapper.BigDecimalWrapper;
import com.thebeastshop.bgel.runtime.wrapper.BigIntegerWrapper;
import com.thebeastshop.bgel.runtime.wrapper.BooleanWrapper;
import com.thebeastshop.bgel.runtime.wrapper.DoubleWrapper;
import com.thebeastshop.bgel.runtime.wrapper.FloatWrapper;
import com.thebeastshop.bgel.runtime.wrapper.IntWrapper;
import com.thebeastshop.bgel.runtime.wrapper.JavaBeanWrapper;
import com.thebeastshop.bgel.runtime.wrapper.LongWrapper;
import com.thebeastshop.bgel.runtime.wrapper.MapWrapper;
import com.thebeastshop.bgel.runtime.wrapper.ShortWrapper;
import com.thebeastshop.bgel.runtime.wrapper.StringWrapper;
import com.thebeastshop.bgel.runtime.wrapper.Wrapper;
import com.thebeastshop.bgel.utils.NumberHelper;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetaHelper {
    public static BgelObject wrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BgelObject) {
            return (BgelObject)obj;
        }
        if (obj instanceof CharSequence) {
            return new StringWrapper((CharSequence)obj);
        }
        if (obj instanceof Boolean) {
            return new BooleanWrapper((Boolean)obj);
        }
        if (obj instanceof Short) {
            return new ShortWrapper((Short)obj);
        }
        if (obj instanceof Integer) {
            return new IntWrapper((Integer)obj);
        }
        if (obj instanceof Long) {
            return new LongWrapper((Long)obj);
        }
        if (obj instanceof BigInteger) {
            return new BigIntegerWrapper((BigInteger)obj);
        }
        if (obj instanceof Float) {
            return new FloatWrapper((Float)obj);
        }
        if (obj instanceof Double) {
            return new DoubleWrapper((Double)obj);
        }
        if (obj instanceof BigDecimal) {
            return new BigDecimalWrapper((BigDecimal)obj);
        }
        if (obj instanceof Map) {
            return new MapWrapper((Map)obj);
        }
        JavaBeanWrapper wrapper = new JavaBeanWrapper(obj, obj.getClass());
        return wrapper;
    }

    public static Object unwrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Wrapper) {
            return ((Wrapper)obj).getOriginalObject();
        }
        return obj;
    }

    public static Object[] wrapArray(Object args) {
        int len = Array.getLength(args);
        Object[] rets = new BgelObject[len];
        for (int i = 0; i < len; ++i) {
            Object elem = Array.get(args, i);
            elem = elem.getClass().isArray() ? MetaHelper.wrapArray(elem) : MetaHelper.wrap(elem);
            rets[i] = elem;
        }
        return rets;
    }

    public static Object[] unwrap(Object[] args) {
        int len = args.length;
        Object[] rets = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object unwrapped;
            Object arg = args[i];
            rets[i] = unwrapped = MetaHelper.unwrap(arg);
        }
        return rets;
    }

    public static List unwrap(List<?> list) {
        ArrayList<Object> newList;
        if (list instanceof BgelObject) {
            return list;
        }
        Class<?> listType = list.getClass();
        try {
            newList = (ArrayList<Object>)listType.newInstance();
        }
        catch (InstantiationException e) {
            newList = new ArrayList<Object>(list.size());
        }
        catch (IllegalAccessException e) {
            newList = new ArrayList(list.size());
        }
        for (Object elem : list) {
            Object obj = MetaHelper.unwrap(elem);
            if (obj instanceof List) {
                obj = MetaHelper.unwrap((List)obj);
            }
            newList.add(obj);
        }
        return newList;
    }

    public static Class autoboxType(Class primitiveType) {
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        return primitiveType;
    }

    public static Object[] castArguments(MethodParameterTypes parameterTypes, Object[] arguments) {
        int len = arguments.length;
        Object[] casted = new Object[len];
        Class[] targetTypes = parameterTypes.getTypes();
        for (int i = 0; i < len; ++i) {
            Class type = MetaHelper.autoboxType(targetTypes[i]);
            Object obj = arguments[i];
            Object castedObj = MetaHelper.cast(type, obj);
            casted[i] = castedObj;
        }
        return casted;
    }

    public static <T> T cast(Class<T> targetType, Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> objClass = obj.getClass();
        if (targetType == obj) {
            return (T)obj;
        }
        if (Number.class.isAssignableFrom(targetType) && obj instanceof Number) {
            return (T)NumberHelper.castNumber(targetType, (Number)obj);
        }
        if (targetType.isAssignableFrom(objClass)) {
            return targetType.cast(obj);
        }
        if (String.class.isAssignableFrom(targetType)) {
            return (T)String.valueOf(obj);
        }
        throw new ClassCastException(obj.toString() + " can not be casted to " + targetType.getName());
    }

    public static int calculateTypeDistance(Class paramType, Class argType) {
        int d;
        if (paramType == argType) {
            return 0;
        }
        if (paramType.isInterface() && (d = MetaHelper.calculateInterfaceDistance(paramType, argType)) > -1) {
            return d;
        }
        int distance = 0;
        Class superClass = argType;
        while (superClass != null && superClass != paramType) {
            superClass = superClass.getSuperclass();
            distance += 3;
        }
        return distance;
    }

    private static int calculateInterfaceDistance(Class interfaceClass, Class targetType) {
        if (interfaceClass == targetType) {
            return 0;
        }
        Class<?>[] interfaces = targetType.getInterfaces();
        int ret = -1;
        for (Class<?> targetInterface : interfaces) {
            int d = MetaHelper.calculateInterfaceDistance(interfaceClass, targetInterface);
            if (d != -1) {
                ++d;
            }
            if (ret >= d) continue;
            ret = d;
        }
        Class superClass = targetType.getSuperclass();
        if (superClass != null) {
            int d = MetaHelper.calculateInterfaceDistance(interfaceClass, superClass);
            if (d != -1) {
                ++d;
            }
            if (ret < d) {
                ret = d;
            }
        }
        return ret;
    }

    public static String toArgumentTypesString(Object[] arguments) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (int i = 0; i < arguments.length; ++i) {
            Object arg = arguments[i];
            arg = MetaHelper.unwrap(arg);
            Class<?> argType = arg.getClass();
            builder.append(argType.getSimpleName());
            if (i >= arguments.length - 1) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }
}

