/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.transform;

import com.thebeastshop.bgel.ast.ASTConstant;
import com.thebeastshop.bgel.ast.ASTNode;
import com.thebeastshop.bgel.ast.ASTType;
import com.thebeastshop.bgel.compile.BgelSource;
import com.thebeastshop.bgel.transform.ExpressionTransformer;
import org.antlr.v4.runtime.Token;

public class ConstantTransformer
extends ExpressionTransformer {
    public ASTConstant transform(BgelSource source, Object value, Token startToken, Token endToken) {
        ASTConstant constant = new ASTConstant(this.filterString(source, value), ASTType.fromJavaClass(value.getClass()));
        this.setPosition((ASTNode)constant, startToken, endToken);
        this.printNode(constant);
        return constant;
    }

    public Object filterString(BgelSource source, Object value) {
        if (source.isScript()) {
            return value;
        }
        if (value instanceof String) {
            String str = (String)value;
            int len = str.length();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch == '\\') {
                    ch = str.charAt(++i);
                    switch (ch) {
                        case 'n': {
                            builder.append('\n');
                            break;
                        }
                        case 'r': {
                            builder.append('\r');
                            break;
                        }
                        default: {
                            builder.append("\\" + ch);
                            break;
                        }
                    }
                    continue;
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return value;
    }
}

