/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.wrapper;

import com.thebeastshop.bgel.runtime.wrapper.Wrapper;
import com.thebeastshop.bgel.utils.MetaHelper;
import com.thebeastshop.bgel.utils.NumberHelper;

public abstract class NumberWrapper<T extends Number>
extends Wrapper
implements Comparable<NumberWrapper> {
    public NumberWrapper(T originalObject, Class<T> originalClass) {
        super(originalObject, originalClass);
    }

    public abstract NumberWrapper negate();

    public Number getNumber() {
        return (Number)this.getOriginalObject();
    }

    @Override
    public int compareTo(NumberWrapper obj) {
        Number number1 = this.getNumber();
        Number number2 = obj.getNumber();
        return NumberHelper.compare(number1, number2);
    }

    public NumberWrapper add(NumberWrapper obj) {
        Number number1 = this.getNumber();
        Number number2 = obj.getNumber();
        return (NumberWrapper)MetaHelper.wrap(NumberHelper.add(number1, number2));
    }

    public NumberWrapper sub(NumberWrapper obj) {
        Number number1 = this.getNumber();
        Number number2 = obj.getNumber();
        return (NumberWrapper)MetaHelper.wrap(NumberHelper.sub(number1, number2));
    }

    public NumberWrapper multi(NumberWrapper obj) {
        Number number1 = this.getNumber();
        Number number2 = obj.getNumber();
        return (NumberWrapper)MetaHelper.wrap(NumberHelper.multi(number1, number2));
    }

    public NumberWrapper div(NumberWrapper obj) {
        Number number1 = this.getNumber();
        Number number2 = obj.getNumber();
        return (NumberWrapper)MetaHelper.wrap(NumberHelper.div(number1, number2));
    }

    public NumberWrapper power(NumberWrapper obj) {
        Number number1 = this.getNumber();
        Number number2 = obj.getNumber();
        return (NumberWrapper)MetaHelper.wrap(NumberHelper.power(number1, number2));
    }

    public Integer intValue() {
        return this.getNumber().intValue();
    }

    public Long longValue() {
        return this.getNumber().longValue();
    }

    public Float floatValue() {
        return Float.valueOf(this.getNumber().floatValue());
    }

    public Double doubleValue() {
        return this.getNumber().doubleValue();
    }
}

