/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.eval;

import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.runtime.BgelTimeDuration;
import com.thebeastshop.bgel.runtime.wrapper.NumberWrapper;
import com.thebeastshop.bgel.utils.TypeHelper;
import java.util.Date;

public class SubEvaluator {
    public Object evaluate(BgelRuntimeContext context, ASTBinaryExpression node, Object left, Object right) {
        if (left instanceof NumberWrapper && right instanceof NumberWrapper) {
            return ((NumberWrapper)left).sub((NumberWrapper)right);
        }
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        if (TypeHelper.isDate(leftClass)) {
            BgelDate leftDate = left instanceof BgelDate ? (BgelDate)left : new BgelDate((Date)left);
            if (TypeHelper.isDate(rightClass)) {
                BgelDate rightDate = right instanceof BgelDate ? (BgelDate)right : new BgelDate((Date)right);
                return leftDate.substract(rightDate);
            }
            if (TypeHelper.isTimeDuration(rightClass)) {
                return leftDate.substract((BgelTimeDuration)right);
            }
        }
        throw new BgelEvalException(context, node, "operator '-' do not support for type " + left.getClass().getName() + " and " + right.getClass().getName());
    }
}

