/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.runtime.MetaClass;
import com.thebeastshop.bgel.runtime.MetaClassFactory;
import com.thebeastshop.bgel.runtime.wrapper.Wrapper;
import com.thebeastshop.bgel.utils.MetaHelper;
import com.thebeastshop.bgel.utils.NumberHelper;
import com.thebeastshop.bgel.utils.TypeHelper;

public class MethodParameterTypes {
    private final Class[] types;
    private final boolean isVarArgs;

    public MethodParameterTypes(Class[] paramTypes, boolean isVarArgs) {
        this.types = new Class[paramTypes.length];
        for (int i = 0; i < this.types.length; ++i) {
            Class clazz;
            this.types[i] = clazz = paramTypes[i];
        }
        this.isVarArgs = isVarArgs;
    }

    public boolean isValidArguments(Object[] args) {
        int len = this.types.length;
        if (len > args.length) {
            return false;
        }
        if (len < args.length && !this.isVarArgs) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            Class paramType = this.types[i];
            paramType = MetaHelper.autoboxType(paramType);
            Object arg = args[i];
            Class argType = arg.getClass();
            if (arg instanceof Wrapper) {
                argType = ((Wrapper)arg).getOriginalClass();
            }
            if (Number.class.isAssignableFrom(paramType) && Number.class.isAssignableFrom(argType)) {
                if (!TypeHelper.isJavaInteger(paramType) && !TypeHelper.isJavaLong(paramType) && !TypeHelper.isJavaShort(paramType) && !TypeHelper.isBigInteger(paramType) || !TypeHelper.isJavaFloat(argType) && !TypeHelper.isJavaDouble(argType) && !TypeHelper.isBigDecimal(argType)) continue;
                return NumberHelper.isRoundFigure((Number)arg);
            }
            if (paramType.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public long calculateDistanceWithArguments(Object[] args) {
        int len = this.types.length;
        long distance = 0L;
        for (int i = 0; i < len; ++i) {
            Class paramType = this.types[i];
            Object arg = args[i];
            arg = MetaHelper.unwrap(arg);
            Class<?> argType = arg.getClass();
            long d = this.calculateDistanceWithType(paramType, argType);
            distance += d;
        }
        return distance;
    }

    public long calculateDistanceWithType(Class paramType, Class argType) {
        MetaClass paramMetaClass = MetaClassFactory.getMetaClass(paramType);
        return paramMetaClass.getTypeDistance(argType);
    }

    public Class[] getTypes() {
        return this.types;
    }

    public int getTypeCount() {
        return this.types.length;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean equalsTypes(Class[] argTypes) {
        if (this.types.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < this.types.length; ++i) {
            Class paramType = this.types[i];
            Class argType = argTypes[i];
            if (paramType == argType) continue;
            return false;
        }
        return true;
    }
}

