/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.runtime.MethodParameterTypes;
import java.lang.reflect.InvocationTargetException;

public abstract class MetaMethod {
    private final String methodName;
    private final int paramTypeCount;
    private final boolean isVarArgs;
    private MethodParameterTypes paramTypes;
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];

    public MetaMethod(String methodName, Class[] paramterTypes, boolean isVarArgs) {
        this.methodName = methodName;
        this.paramTypeCount = paramterTypes.length;
        this.isVarArgs = isVarArgs;
        this.paramTypes = new MethodParameterTypes(paramterTypes, isVarArgs);
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public int getParamTypeCount() {
        return this.paramTypeCount;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public MethodParameterTypes getParamTypes() {
        return this.paramTypes;
    }

    public Object invokeWithEmptyArguments(Object self) throws InvocationTargetException, IllegalAccessException {
        return this.invoke(self, EMPTY_ARGUMENTS);
    }

    public abstract Object invoke(Object var1, Object[] var2) throws InvocationTargetException, IllegalAccessException;

    public String getMethodDeclarationName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.methodName);
        builder.append(" (");
        Class[] pTypes = this.paramTypes.getTypes();
        for (int i = 0; i < pTypes.length; ++i) {
            Class pt = pTypes[i];
            builder.append(pt.getSimpleName());
            if (i >= pTypes.length - 1) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }
}

