/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.exception.BgelAccessException;
import com.thebeastshop.bgel.exception.BgelAmbiguousMethodsException;
import com.thebeastshop.bgel.runtime.DefaultMetaMethod;
import com.thebeastshop.bgel.runtime.MetaMethod;
import com.thebeastshop.bgel.runtime.MetaProperty;
import com.thebeastshop.bgel.runtime.SameNameMethodCollection;
import com.thebeastshop.bgel.utils.AccessUtils;
import com.thebeastshop.bgel.utils.MetaHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public abstract class MetaClass {
    private final Class<?> clazz;
    private boolean isInitialized = false;
    private final Map<String, Field> publicFields = new HashMap<String, Field>();
    private final Map<String, MetaProperty> properties = new HashMap<String, MetaProperty>();
    private final Map<String, MetaMethod> nonParamsMethods = new HashMap<String, MetaMethod>();
    private final Map<String, SameNameMethodCollection> methods = new HashMap<String, SameNameMethodCollection>();
    private final Map<String, MetaMethod> staticNonParamsMethods = new HashMap<String, MetaMethod>();
    private final Map<String, SameNameMethodCollection> staticMethods = new HashMap<String, SameNameMethodCollection>();
    private final Map<Class, Integer> typeDistanceMap = new HashMap<Class, Integer>();

    public MetaClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.initializePublicFields();
            this.initializePropertiesAndMethods();
            this.initializeTypeDistance(this.typeDistanceMap);
            this.isInitialized = true;
        }
    }

    private void initializeTypeDistance(Map<Class, Integer> typeDistanceMap) {
    }

    private void initializePublicFields() {
        Field[] fields;
        if (this.clazz.isPrimitive()) {
            return;
        }
        for (Field field : fields = this.clazz.getFields()) {
            if (!field.isAccessible()) continue;
            this.publicFields.put(field.getName(), field);
        }
    }

    protected void initializePropertiesAndMethods() {
        Method[] methods;
        for (Method method : methods = this.clazz.getMethods()) {
            MetaMethod metaMethod;
            SameNameMethodCollection sameNameMethodCollection;
            String name;
            String keyName = name = method.getName();
            Class[] paramTypes = method.getParameterTypes();
            boolean isVarArgs = method.isVarArgs();
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                if (paramTypes.length == 0 && !isVarArgs) {
                    DefaultMetaMethod staticNonParamsMethod = new DefaultMetaMethod(method);
                    this.staticNonParamsMethods.put(name, staticNonParamsMethod);
                    continue;
                }
                sameNameMethodCollection = this.staticMethods.get(keyName);
                if (sameNameMethodCollection == null) {
                    sameNameMethodCollection = new SameNameMethodCollection(name);
                    this.staticMethods.put(keyName, sameNameMethodCollection);
                }
                metaMethod = new DefaultMetaMethod(method);
                sameNameMethodCollection.addMethod(metaMethod);
                continue;
            }
            if (paramTypes.length == 0 && !isVarArgs) {
                if (AccessUtils.isGetterName(name)) {
                    String propName = AccessUtils.getPropertyName(name);
                    if (propName == null) {
                        throw new RuntimeException("'" + name + "' can not be a Property");
                    }
                    MetaProperty property = new MetaProperty(propName, method);
                    this.properties.put(propName, property);
                }
                DefaultMetaMethod nonParamsMethod = new DefaultMetaMethod(method);
                this.nonParamsMethods.put(name, nonParamsMethod);
                continue;
            }
            sameNameMethodCollection = this.methods.get(keyName);
            if (sameNameMethodCollection == null) {
                sameNameMethodCollection = new SameNameMethodCollection(name);
                this.methods.put(keyName, sameNameMethodCollection);
            }
            if ((metaMethod = sameNameMethodCollection.getSameParamTypesMethod(paramTypes)) != null) continue;
            metaMethod = new DefaultMetaMethod(method);
            sameNameMethodCollection.addMethod(metaMethod);
        }
    }

    public void setTypeDistance(Class type, int distance) {
        this.typeDistanceMap.put(type, distance);
    }

    public MetaMethod getMethod(String methodName, Object[] arguments) throws BgelAmbiguousMethodsException {
        if (arguments.length == 0) {
            return this.nonParamsMethods.get(methodName);
        }
        SameNameMethodCollection sameNameMethodCollection = this.methods.get(methodName);
        if (sameNameMethodCollection == null) {
            return null;
        }
        return sameNameMethodCollection.chooseMethod(this.clazz, arguments);
    }

    public MetaMethod getStaticMethod(String methodName, Object[] arguments) throws BgelAmbiguousMethodsException {
        if (arguments.length == 0) {
            return this.staticNonParamsMethods.get(methodName);
        }
        SameNameMethodCollection sameNameMethodCollection = this.staticMethods.get(methodName);
        if (sameNameMethodCollection == null) {
            return null;
        }
        return sameNameMethodCollection.chooseMethod(this.clazz, arguments);
    }

    public Field getField(String fieldName) {
        return this.publicFields.get(fieldName);
    }

    public MetaProperty getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Object access(Object self, String name) throws InvocationTargetException, IllegalAccessException, BgelAccessException {
        MetaMethod metaMethod = this.nonParamsMethods.get(name);
        if (metaMethod != null) {
            return metaMethod.invokeWithEmptyArguments(self);
        }
        MetaProperty metaProperty = this.getProperty(name);
        if (metaProperty != null) {
            return metaProperty.getValue(self);
        }
        Field field = this.getField(name);
        if (field != null) {
            return field.get(self);
        }
        throw new BgelAccessException(this.clazz, name);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Object invokeMethod(Object self, String methodName, Object[] arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, BgelAmbiguousMethodsException {
        Object[] unwrappedArgs = MetaHelper.unwrap(arguments);
        MetaMethod metaMethod = this.getMethod(methodName, unwrappedArgs);
        if (metaMethod == null) {
            String msg = this.clazz.getName() + "." + methodName + MetaHelper.toArgumentTypesString(arguments);
            throw new NoSuchMethodException(msg);
        }
        return metaMethod.invoke(self, unwrappedArgs);
    }

    public Object invokeStaticMethod(String methodName, Object[] arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, BgelAmbiguousMethodsException {
        Object[] unwrappedArgs = MetaHelper.unwrap(arguments);
        MetaMethod metaMethod = this.getStaticMethod(methodName, unwrappedArgs);
        if (metaMethod == null) {
            String msg = this.clazz.getName() + "." + methodName + MetaHelper.toArgumentTypesString(arguments);
            throw new NoSuchMethodException(msg);
        }
        return metaMethod.invoke(null, unwrappedArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTypeDistance(Class type) {
        Integer distance = this.typeDistanceMap.get(type);
        if (distance == null) {
            distance = MetaHelper.calculateTypeDistance(this.clazz, type);
            Map<Class, Integer> map = this.typeDistanceMap;
            synchronized (map) {
                if (!this.typeDistanceMap.containsKey(type)) {
                    this.typeDistanceMap.put(type, distance);
                }
            }
        }
        return distance.intValue();
    }
}

