/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.ast.ASTAccessExpression;
import com.thebeastshop.bgel.ast.ASTBinaryExpression;
import com.thebeastshop.bgel.ast.ASTConstant;
import com.thebeastshop.bgel.ast.ASTDate;
import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTIdentifier;
import com.thebeastshop.bgel.ast.ASTIndexExpression;
import com.thebeastshop.bgel.ast.ASTInvokeExpression;
import com.thebeastshop.bgel.ast.ASTList;
import com.thebeastshop.bgel.ast.ASTMap;
import com.thebeastshop.bgel.ast.ASTMapEntry;
import com.thebeastshop.bgel.ast.ASTNegativeExpression;
import com.thebeastshop.bgel.ast.ASTNotExpression;
import com.thebeastshop.bgel.ast.ASTNull;
import com.thebeastshop.bgel.ast.ASTRange;
import com.thebeastshop.bgel.ast.ASTTernaryExpression;
import com.thebeastshop.bgel.ast.ASTTimeDuration;
import com.thebeastshop.bgel.ast.ASTType;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.exception.BgelEvalException;
import com.thebeastshop.bgel.runtime.BgelDate;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.runtime.BgelTimeDuration;
import com.thebeastshop.bgel.runtime.eval.AccessEvaluator;
import com.thebeastshop.bgel.runtime.eval.AddEvaluator;
import com.thebeastshop.bgel.runtime.eval.BooleanEvaluator;
import com.thebeastshop.bgel.runtime.eval.CompareEvaluator;
import com.thebeastshop.bgel.runtime.eval.ConstantEvaluator;
import com.thebeastshop.bgel.runtime.eval.DivideEvaluator;
import com.thebeastshop.bgel.runtime.eval.IdentifierEvaluator;
import com.thebeastshop.bgel.runtime.eval.InEvaluator;
import com.thebeastshop.bgel.runtime.eval.IndexEvaluator;
import com.thebeastshop.bgel.runtime.eval.InvokeEvaluator;
import com.thebeastshop.bgel.runtime.eval.MultiplyEvaluator;
import com.thebeastshop.bgel.runtime.eval.PowerEvaluator;
import com.thebeastshop.bgel.runtime.eval.RangeEvaluator;
import com.thebeastshop.bgel.runtime.eval.RegexMatchEvaluator;
import com.thebeastshop.bgel.runtime.eval.RemainderEvaluator;
import com.thebeastshop.bgel.runtime.eval.SubEvaluator;
import com.thebeastshop.bgel.runtime.wrapper.NumberWrapper;
import com.thebeastshop.bgel.utils.MetaHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class BgelEvalVisitor
implements ASTVisitor {
    private final ConstantEvaluator constantEvaluator = new ConstantEvaluator();
    private final IdentifierEvaluator identifierEvaluator = new IdentifierEvaluator();
    private final RangeEvaluator rangeEvaluator = new RangeEvaluator();
    private final AddEvaluator addEvaluator = new AddEvaluator();
    private final SubEvaluator subEvaluator = new SubEvaluator();
    private final MultiplyEvaluator multiplyEvaluator = new MultiplyEvaluator();
    private final DivideEvaluator divideEvaluator = new DivideEvaluator();
    private final RemainderEvaluator remainderEvaluator = new RemainderEvaluator();
    private final PowerEvaluator powerEvaluator = new PowerEvaluator();
    private final CompareEvaluator compareEvaluator = new CompareEvaluator();
    private final RegexMatchEvaluator regexMatchEvaluator = new RegexMatchEvaluator();
    private final BooleanEvaluator booleanEvaluator = new BooleanEvaluator();
    private final InEvaluator inEvaluator = new InEvaluator();
    private final AccessEvaluator accessEvaluator = new AccessEvaluator();
    private final IndexEvaluator indexEvaluator = new IndexEvaluator();
    private final InvokeEvaluator invokeEvaluator = new InvokeEvaluator();

    @Override
    public void visitType(BgelRuntimeContext context, ASTType node) {
    }

    @Override
    public void visitConstant(BgelRuntimeContext context, ASTConstant node) {
        Object result = this.constantEvaluator.evaluate(context, node);
        context.setResult(result);
    }

    @Override
    public void visitRange(BgelRuntimeContext context, ASTRange node) {
        ASTExpression fromExpr = node.getFrom();
        ASTExpression toExpr = node.getTo();
        fromExpr.visit(context, this);
        Comparable from = (Comparable)context.getResult();
        toExpr.visit(context, this);
        Comparable to = (Comparable)context.getResult();
        Object result = this.rangeEvaluator.evaluate(context, node, from, to);
        context.setResult(result);
    }

    private void setHHMMSSss(BgelRuntimeContext context, Calendar calendar, ASTExpression hoursExpr, ASTExpression minutesExpr, ASTExpression secondsExpr, ASTExpression millisecondsExpr) {
        if (hoursExpr != null && minutesExpr != null) {
            hoursExpr.visit(context, this);
            Integer hours = (Integer)MetaHelper.unwrap(context.getResult());
            minutesExpr.visit(context, this);
            Integer minutes = (Integer)MetaHelper.unwrap(context.getResult());
            calendar.set(11, hours);
            calendar.set(12, minutes);
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
        }
        if (secondsExpr != null) {
            secondsExpr.visit(context, this);
            Integer seconds = (Integer)MetaHelper.unwrap(context.getResult());
            calendar.set(13, seconds);
        } else {
            calendar.set(13, 0);
        }
        if (millisecondsExpr != null) {
            millisecondsExpr.visit(context, this);
            Integer milliseconds = (Integer)MetaHelper.unwrap(context.getResult());
            calendar.set(14, milliseconds);
        } else {
            calendar.set(14, 0);
        }
    }

    @Override
    public void visitDate(BgelRuntimeContext context, ASTDate node) {
        Calendar calendar = Calendar.getInstance();
        ASTExpression yearExpr = node.getYear();
        ASTExpression monthExpr = node.getMonth();
        ASTExpression dayExpr = node.getDay();
        ASTExpression hoursExpr = node.getHours();
        ASTExpression minutesExpr = node.getMinutes();
        ASTExpression secondsExpr = node.getSeconds();
        ASTExpression millisecondsExpr = node.getMilliseconds();
        yearExpr.visit(context, this);
        Integer year = (Integer)MetaHelper.unwrap(context.getResult());
        monthExpr.visit(context, this);
        Integer month = (Integer)MetaHelper.unwrap(context.getResult());
        dayExpr.visit(context, this);
        Integer day = (Integer)MetaHelper.unwrap(context.getResult());
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        this.setHHMMSSss(context, calendar, hoursExpr, minutesExpr, secondsExpr, millisecondsExpr);
        Date time = calendar.getTime();
        BgelDate date = new BgelDate(time);
        context.setResult(date);
    }

    @Override
    public void visitTimeDuration(BgelRuntimeContext context, ASTTimeDuration node) {
        ASTExpression hoursExpr = node.getHours();
        ASTExpression minutesExpr = node.getMinutes();
        ASTExpression secondsExpr = node.getSeconds();
        ASTExpression millisecondsExpr = node.getMilliseconds();
        Integer hours = 0;
        Integer minutes = 0;
        Integer seconds = 0;
        Integer milliseconds = 0;
        if (hoursExpr != null && minutesExpr != null) {
            hoursExpr.visit(context, this);
            hours = (Integer)MetaHelper.unwrap(context.getResult());
            minutesExpr.visit(context, this);
            minutes = (Integer)MetaHelper.unwrap(context.getResult());
        }
        if (secondsExpr != null) {
            secondsExpr.visit(context, this);
            seconds = (Integer)MetaHelper.unwrap(context.getResult());
        }
        if (millisecondsExpr != null) {
            millisecondsExpr.visit(context, this);
            milliseconds = (Integer)MetaHelper.unwrap(context.getResult());
        }
        BgelTimeDuration timeDuration = new BgelTimeDuration(0, hours, minutes, seconds, milliseconds);
        context.setResult(timeDuration);
    }

    @Override
    public void visitList(BgelRuntimeContext context, ASTList node) {
        List<ASTExpression> items = node.getListItems();
        ArrayList<Object> list = new ArrayList<Object>();
        for (ASTExpression item : items) {
            item.visit(context, this);
            list.add(context.getResult());
        }
        context.setResult(list);
    }

    @Override
    public void visitMap(BgelRuntimeContext context, ASTMap node) {
        List<ASTMapEntry> entries = node.getEntryList();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (ASTMapEntry entry : entries) {
            entry.visit(context, this);
            Object[] pair = (Object[])context.getResult();
            Object key = pair[0];
            Object value = pair[1];
            map.put(key, value);
        }
        context.setResult(map);
    }

    @Override
    public void visitMapEntry(BgelRuntimeContext context, ASTMapEntry node) {
        ASTExpression keyExpr = node.getKey();
        ASTExpression valueExpr = node.getValue();
        keyExpr.visit(context, this);
        Object key = context.getResult();
        valueExpr.visit(context, this);
        Object value = context.getResult();
        Object[] keyValuePair = new Object[]{key, value};
        context.setResult(keyValuePair);
    }

    @Override
    public void visitNull(BgelRuntimeContext context, ASTNull node) {
        context.setResult(null);
    }

    @Override
    public void visitIdentifier(BgelRuntimeContext context, ASTIdentifier node) {
        Object ret = this.identifierEvaluator.evaluate(context, node);
        context.setResult(ret);
    }

    @Override
    public void visitBinaryExpression(BgelRuntimeContext context, ASTBinaryExpression node) {
        ASTExpression leftExpr = node.getLeft();
        ASTExpression rightExpr = node.getRight();
        leftExpr.visit(context, this);
        Object left = context.getResult();
        rightExpr.visit(context, this);
        Object right = context.getResult();
        Token op = node.getOperation();
        int opType = op.getType();
        Object ret = null;
        switch (opType) {
            case 25: {
                ret = this.addEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 26: {
                ret = this.subEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 27: {
                ret = this.multiplyEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 28: {
                ret = this.divideEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 29: {
                ret = this.remainderEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 30: {
                ret = this.powerEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                ret = this.booleanEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                ret = this.compareEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 33: {
                ret = this.regexMatchEvaluator.evaluate(context, node, left, right);
                break;
            }
            case 31: 
            case 32: {
                ret = this.inEvaluator.evaluate(context, node, left, right);
            }
        }
        context.setResult(ret);
    }

    @Override
    public void visitTernaryExpression(BgelRuntimeContext context, ASTTernaryExpression node) {
        node.getCondition().visit(context, this);
        Object conRet = MetaHelper.unwrap(context.getResult());
        if (conRet == null || conRet == Boolean.valueOf(false)) {
            if (node.getFalseExpression() != null) {
                node.getFalseExpression().visit(context, this);
            } else {
                context.setResult(null);
            }
        } else if (node.getTrueExpression() != null) {
            node.getTrueExpression().visit(context, this);
        } else {
            context.setResult(context.getResult());
        }
    }

    @Override
    public void visitNegativeExpression(BgelRuntimeContext context, ASTNegativeExpression node) {
        node.getExpression().visit(context, this);
        Object right = context.getResult();
        try {
            NumberWrapper numberWrapper = (NumberWrapper)right;
            NumberWrapper ret = numberWrapper.negate();
            context.setResult(ret);
        }
        catch (Throwable th) {
            throw new BgelEvalException(context, node, "Operator '-' can not applied to " + right.getClass().getName());
        }
    }

    @Override
    public void visitNotExpression(BgelRuntimeContext context, ASTNotExpression node) {
    }

    @Override
    public void visitAccessExpression(BgelRuntimeContext context, ASTAccessExpression node) {
        node.getLeft().visit(context, this);
        Object left = context.getResult();
        Object ret = this.accessEvaluator.evaluate(context, node, left);
        context.setResult(ret);
    }

    @Override
    public void visitIndexExpression(BgelRuntimeContext context, ASTIndexExpression node) {
        node.getLeft().visit(context, this);
        Object left = context.getResult();
        node.getIndex().visit(context, this);
        Object index = context.getResult();
        Object ret = this.indexEvaluator.evaluate(context, node, left, index);
        context.setResult(ret);
    }

    @Override
    public void visitInvokeExpression(BgelRuntimeContext context, ASTInvokeExpression node) {
        ASTExpression leftExpr = node.getLeft();
        Object left = null;
        if (leftExpr != null) {
            leftExpr.visit(context, this);
            left = context.getResult();
        }
        List<ASTExpression> argExprs = node.getArguments();
        Object[] args = new Object[argExprs.size()];
        for (int i = 0; i < argExprs.size(); ++i) {
            ASTExpression argExpr = argExprs.get(i);
            argExpr.visit(context, this);
            args[i] = context.getResult();
        }
        Object ret = this.invokeEvaluator.evaluate(context, node, left, args);
        context.setResult(ret);
    }
}

