/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime;

import com.thebeastshop.bgel.exception.BgelException;
import com.thebeastshop.bgel.runtime.BgelObjectSupport;
import com.thebeastshop.bgel.runtime.BgelTimeDuration;
import com.thebeastshop.bgel.runtime.MetaClass;
import com.thebeastshop.bgel.runtime.MetaClassFactory;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class BgelDate
extends BgelObjectSupport
implements Comparable {
    private Date date;
    private TimeZone timeZone;

    public BgelDate(Date date, String timeZone) {
        this(date, timeZone == null || timeZone.isEmpty() ? null : TimeZone.getTimeZone(timeZone));
    }

    public BgelDate(Date date, TimeZone timeZone) {
        this.timeZone = timeZone != null ? timeZone : TimeZone.getDefault();
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        this.date = date;
    }

    public BgelDate(Date date) {
        this.date = date;
        this.timeZone = TimeZone.getDefault();
    }

    public BgelDate(long time) {
        this.date = new Date(time);
        this.timeZone = TimeZone.getDefault();
    }

    public BgelDate() {
        this(new Date());
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        return calendar;
    }

    public Calendar getCalendar() {
        return this.getCalendar(this.date);
    }

    private int getCalendarValue(int t) {
        Calendar calendar = this.getCalendar();
        return calendar.get(t);
    }

    private void setCalendarValue(int t, int v) {
        Calendar calendar = this.getCalendar();
        calendar.set(t, v);
        this.date = calendar.getTime();
    }

    private static int toCalendarMonthConstant(int month) {
        switch (month) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 11;
            }
        }
        throw new BgelException(month + " is a invalid month");
    }

    private static int fromCalendarMonthConstant(int calendarMonth) {
        switch (calendarMonth) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 12;
            }
        }
        throw new BgelException(calendarMonth + " is not a month constant of class Calendar");
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public int getYear() {
        return this.getCalendarValue(1);
    }

    public int getMonth() {
        return BgelDate.fromCalendarMonthConstant(this.getCalendarValue(2));
    }

    public int getDay() {
        return this.getCalendarValue(5);
    }

    public int getHour() {
        return this.getCalendarValue(11);
    }

    public int getMinute() {
        return this.getCalendarValue(12);
    }

    public int getSecond() {
        return this.getCalendarValue(13);
    }

    public int getMilisecond() {
        return this.getCalendarValue(14);
    }

    public BgelDate add(BgelTimeDuration timeDuration) {
        long newTime = this.date.getTime() + timeDuration.getMilisecond();
        return new BgelDate(newTime);
    }

    public BgelDate substract(BgelTimeDuration timeDuration) {
        long newTime = this.date.getTime() - timeDuration.getMilisecond();
        return new BgelDate(newTime);
    }

    public BgelTimeDuration substract(Date date) {
        long newTime = this.date.getTime() - date.getTime();
        return new BgelTimeDuration(newTime);
    }

    public BgelTimeDuration substract(BgelDate date) {
        return this.substract(date.getDate());
    }

    public boolean after(Date date) {
        return this.date.after(date);
    }

    public boolean before(Date date) {
        return this.date.before(date);
    }

    public boolean greaterThan(Date date) {
        return this.after(date);
    }

    public boolean lessThan(Date date) {
        return this.before(date);
    }

    public boolean greaterEquals(Date date) {
        return this.date.equals(date) || this.after(date);
    }

    public boolean lessEquals(Date date) {
        return this.date.equals(date) || this.before(date);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Date) {
            return this.date.equals(obj);
        }
        if (obj instanceof BgelDate) {
            return this.date.equals(((BgelDate)obj).getDate());
        }
        return false;
    }

    public String format(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        if (this.timeZone != null) {
            format.setTimeZone(this.timeZone);
        } else {
            format.setTimeZone(TimeZone.getDefault());
        }
        return format.format(this.date);
    }

    public String format(String pattern, Locale locale) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        return format.format(this.date);
    }

    public String format(String pattern, TimeZone zone) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        if (zone != null) {
            format.setTimeZone(zone);
        }
        return format.format(this.date);
    }

    public String format(String pattern, String zone) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        if (zone != null) {
            format.setTimeZone(TimeZone.getTimeZone(zone));
        }
        return format.format(this.date);
    }

    public BgelDate clone() {
        Date cloneDate = (Date)this.date.clone();
        BgelDate newDate = new BgelDate(cloneDate);
        return newDate;
    }

    public BgelDate clone(TimeZone zone) {
        Calendar cal = Calendar.getInstance(zone);
        cal.clear();
        cal.set(1, this.getYear());
        cal.set(2, this.getMonth());
        cal.set(5, this.getDay());
        cal.set(11, this.getHour());
        cal.set(12, this.getMinute());
        cal.set(13, this.getSecond());
        BgelDate newDate = new BgelDate(cal.getTime(), zone);
        return newDate;
    }

    public BgelDate clone(String zone) {
        TimeZone tz = TimeZone.getTimeZone(zone);
        return this.clone(tz);
    }

    public String toString() {
        int hour = this.getHour();
        int minute = this.getMinute();
        int second = this.getSecond();
        String format = "yyyy-MM-dd";
        if (hour > 0 || minute > 0 || second > 0) {
            format = format + " hh:mm:ss";
        }
        if (this.timeZone != null) {
            format = format + " Z(z)";
        }
        return this.format(format, this.timeZone);
    }

    public int compareTo(Object o) {
        if (o instanceof Date) {
            Date d = (Date)o;
            if (this.after(d)) {
                return 1;
            }
            if (this.before(d)) {
                return -1;
            }
            return 0;
        }
        if (o instanceof BgelDate) {
            BgelDate d = (BgelDate)o;
            if (this.after(d.getDate())) {
                return 1;
            }
            if (this.before(d.getDate())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public MetaClass getMetaClass() {
        return MetaClassFactory.getMetaClass(this.getClass());
    }
}

