/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.exception;

import com.thebeastshop.bgel.compile.BgelParseError;
import com.thebeastshop.bgel.compile.BgelSource;
import com.thebeastshop.bgel.exception.BgelException;
import java.util.List;

public class BgelParseException
extends BgelException {
    public BgelParseException(BgelSource source, List<BgelParseError> errors) {
        super(false, BgelParseException.getErrorMsg(source, errors));
    }

    protected static String getErrorMsg(BgelSource source, List<BgelParseError> errors) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        int len = errors.size();
        for (int i = 0; i < len; ++i) {
            BgelParseError error = errors.get(i);
            String errMsg = "  " + BgelParseException.getBgelMark() + " error[parse]: " + error.getMsg() + "\n\n" + BgelParseException.getIndentSpace(9) + BgelParseException.getBody(source, error.getPosition());
            builder.append(errMsg);
            if (i >= len - 1) continue;
            builder.append("    ...");
            builder.append("\n\n");
        }
        return builder.toString();
    }
}

