/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.exception;

import com.thebeastshop.bgel.compile.BgelSource;
import com.thebeastshop.bgel.compile.BgelSourceLine;
import com.thebeastshop.bgel.compile.BgelSourcePosition;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import com.thebeastshop.bgel.utils.AnsiHelper;
import java.lang.reflect.Method;
import java.util.List;
import org.fusesource.jansi.Ansi;

public class BgelException
extends RuntimeException {
    private static final String ERROR_LINE_COLOR = AnsiHelper.fg(Ansi.Color.RED);
    private static final String BGEL_MARK_COLOR = AnsiHelper.fg(Ansi.Color.CYAN);
    private static final String SOURCE_COLOR = AnsiHelper.fg(Ansi.Color.YELLOW);
    private static final String BOLD = AnsiHelper.bold();
    private static final String RESET = AnsiHelper.reset();

    public BgelException(String msg) {
        this(true, msg);
    }

    public BgelException(String msg, Throwable cause) {
        this(true, msg, cause);
    }

    public BgelException(boolean autoPrefix, String msg) {
        super(autoPrefix ? BgelException.getErrorMsg(msg) : msg);
    }

    public BgelException(boolean autoPrefix, String msg, Throwable cause) {
        super(autoPrefix ? BgelException.getErrorMsg(msg) : msg, cause);
        Method[] methods;
        Class<?> clazz = this.getClass();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals("printEnclosedStackTrace")) continue;
            method.setAccessible(true);
        }
    }

    protected static String getErrorMsg(String msg) {
        return "\n  " + BgelException.getBgelMark() + " error: " + msg;
    }

    protected static String getErrorMsg(BgelRuntimeContext context, BgelSourcePosition position, String msg) {
        return "\n  " + BgelException.getBgelMark() + " error[runtime]: " + msg + "\n\n" + BgelException.getIndentSpace(9) + BgelException.getBody(context.getSource(), position);
    }

    protected static String getBody(BgelSource source, BgelSourcePosition position) {
        return "--> " + source.getSourceName() + ":" + position.getStartLine() + ":" + position.getStartColumn() + "\n\n" + BgelException.getSourcePart(source, position, 16);
    }

    protected static String getBgelMark() {
        return "[" + BGEL_MARK_COLOR + BOLD + "BGEL" + RESET + "]";
    }

    protected static String getSourcePart(BgelSource source, BgelSourcePosition position, int indent) {
        List<BgelSourceLine> lineList = source.getLineList(0, position.getEndLine());
        if (lineList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int startLine = position.getStartLine();
        int startColumn = position.getStartColumn();
        for (BgelSourceLine line : lineList) {
            builder.append(BgelException.getIndentSpace(indent));
            builder.append(SOURCE_COLOR);
            builder.append(line.getLine());
            builder.append(ERROR_LINE_COLOR);
            if (line.getLineNumber() == startLine) {
                int i;
                builder.append('\n');
                builder.append(BgelException.getIndentSpace(indent));
                for (i = 0; i < startColumn; ++i) {
                    builder.append(' ');
                }
                for (i = startColumn; i < position.getEndColumn(); ++i) {
                    builder.append('^');
                }
            }
            builder.append(RESET);
            builder.append('\n');
        }
        return builder.toString();
    }

    protected static String getIndentSpace(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        AnsiHelper.stopAnsiConsole();
        return this.getMessage();
    }
}

