/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.compile;

import com.thebeastshop.bgel.compile.BgelSourceLine;
import com.thebeastshop.bgel.compile.BgelSourcePosition;
import com.thebeastshop.bgel.exception.BgelException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class BgelSource {
    public static final int SOURCE_TEXT = 1;
    public static final int SOURCE_FILE = 2;
    private InputStream inputStream;
    private String sourceText;
    private int sourceType;
    private String sourceName;
    private final boolean isScript;
    private static Charset UTF8 = Charset.forName("UTF-8");

    public BgelSource(String text, String sourceName) {
        this(true, new ByteArrayInputStream(text.getBytes(UTF8)), 1, sourceName);
        this.sourceText = text;
    }

    public BgelSource(File file) throws FileNotFoundException {
        this(false, new FileInputStream(file), 2, file.getAbsolutePath());
    }

    public BgelSource(boolean isScript, InputStream inputStream, int sourceType, String sourceName) {
        this.inputStream = inputStream;
        this.sourceType = sourceType;
        this.sourceName = sourceName;
        this.isScript = isScript;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public List<BgelSourceLine> getLineList(int startLine, int endLine) {
        BufferedReader reader = new BufferedReader(new StringReader(this.sourceText));
        int lineNum = 1;
        LinkedList<BgelSourceLine> lineList = new LinkedList<BgelSourceLine>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (lineNum >= startLine && lineNum <= endLine) {
                    lineList.add(new BgelSourceLine(lineNum, line));
                }
                ++lineNum;
            }
        }
        catch (IOException e) {
            throw new BgelException("Failed read source at line " + lineNum);
        }
        return lineList;
    }

    public List<BgelSourceLine> getLineList(BgelSourcePosition position) {
        return this.getLineList(position.getStartLine(), position.getEndLine());
    }

    public boolean isScript() {
        return this.isScript;
    }
}

