/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.compile;

import com.thebeastshop.bgel.compile.BgelParseError;
import com.thebeastshop.bgel.compile.BgelSource;
import com.thebeastshop.bgel.compile.BgelSourcePosition;
import com.thebeastshop.bgel.exception.BgelParseException;
import com.thebeastshop.bgel.utils.ThrowUtils;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class BgelErrorListener
extends BaseErrorListener {
    private List<BgelParseError> errors = new ArrayList<BgelParseError>();
    private final BgelSource source;
    private int maxErrorNumber = 10;

    public BgelErrorListener(BgelSource source, Integer maxErrorNumber) {
        this.source = source;
        if (maxErrorNumber != null) {
            this.maxErrorNumber = maxErrorNumber;
        }
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        this.addError(line, charPositionInLine, charPositionInLine + 1, msg);
    }

    public void addError(int line, int startColumn, int endColumn, String msg) {
        BgelSourcePosition position = new BgelSourcePosition(line, line, startColumn, endColumn);
        BgelParseError error = new BgelParseError(position, msg);
        this.errors.add(error);
        if (this.errors.size() >= this.maxErrorNumber) {
            this.throwParseException();
        }
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    private void throwParseException() {
        BgelParseException ex = new BgelParseException(this.source, this.errors);
        ThrowUtils.throwWithoutBgelPackages(ex);
    }

    public void interruptIfHasError() {
        if (this.hasError()) {
            this.throwParseException();
        }
    }
}

