/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.ast;

import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTType;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;

public class ASTTernaryExpression
extends ASTExpression {
    private final ASTExpression condition;
    private final ASTExpression trueExpression;
    private final ASTExpression falseExpression;

    public ASTTernaryExpression(ASTExpression condition, ASTExpression trueExpression, ASTExpression falseExpression) {
        super(ASTType.BOOLEAN);
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.condition);
        builder.append(" ? ");
        builder.append(this.trueExpression);
        if (this.falseExpression != null) {
            builder.append(" : ");
            builder.append(this.falseExpression);
        }
        return builder.toString();
    }

    @Override
    public void visit(BgelRuntimeContext context, ASTVisitor visitor) {
        visitor.visitTernaryExpression(context, this);
    }

    public ASTExpression getCondition() {
        return this.condition;
    }

    public ASTExpression getTrueExpression() {
        return this.trueExpression;
    }

    public ASTExpression getFalseExpression() {
        return this.falseExpression;
    }
}

