/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.ast;

import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTType;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;

public class ASTRange
extends ASTExpression {
    private final ASTExpression from;
    private final ASTExpression to;
    private final boolean includeFrom;
    private final boolean includeTo;

    public ASTRange(ASTExpression from, ASTExpression to, boolean includeFrom, boolean includeTo) {
        super(ASTType.RANGE);
        this.from = from;
        this.to = to;
        this.includeFrom = includeFrom;
        this.includeTo = includeTo;
    }

    public ASTExpression getFrom() {
        return this.from;
    }

    public ASTExpression getTo() {
        return this.to;
    }

    public boolean isIncludeFrom() {
        return this.includeFrom;
    }

    public boolean isIncludeTo() {
        return this.includeTo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.includeFrom ? (char)'[' : '(');
        builder.append(this.from);
        builder.append(" .. ");
        builder.append(this.to);
        builder.append(this.includeTo ? (char)']' : ')');
        return builder.toString();
    }

    @Override
    public String getText() {
        return this.toString();
    }

    @Override
    public void visit(BgelRuntimeContext context, ASTVisitor visitor) {
        visitor.visitRange(context, this);
    }
}

