/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.ast;

import com.thebeastshop.bgel.ast.ASTExpression;
import com.thebeastshop.bgel.ast.ASTType;
import com.thebeastshop.bgel.ast.ASTVisitor;
import com.thebeastshop.bgel.runtime.BgelRuntimeContext;
import java.util.List;

public class ASTInvokeExpression
extends ASTExpression {
    private ASTExpression left;
    private String methodName;
    private boolean isStatic = false;
    private ASTType staticType;
    private final List<ASTExpression> arguments;

    public ASTInvokeExpression(List<ASTExpression> arguments) {
        super(ASTType.UNDEFINED);
        this.arguments = arguments;
    }

    public ASTExpression getLeft() {
        return this.left;
    }

    public void setLeft(ASTExpression left) {
        this.left = left;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<ASTExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        if (this.left != null) {
            builder.append(this.left.toString());
            builder.append('.');
        }
        builder.append(this.methodName);
        builder.append('(');
        for (int i = 0; i < this.arguments.size(); ++i) {
            ASTExpression argExpr = this.arguments.get(i);
            builder.append(argExpr.toString());
            if (i >= this.arguments.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void visit(BgelRuntimeContext context, ASTVisitor visitor) {
        visitor.visitInvokeExpression(context, this);
    }

    public String toString() {
        return this.getText();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public ASTType getStaticType() {
        return this.staticType;
    }

    public void setStaticType(ASTType staticType) {
        this.staticType = staticType;
    }
}

