/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.bgel.runtime.wrapper;

import com.thebeastshop.bgel.exception.BgelAccessException;
import com.thebeastshop.bgel.runtime.BgelObject;
import com.thebeastshop.bgel.runtime.MetaClass;
import com.thebeastshop.bgel.runtime.MetaClassFactory;
import java.lang.reflect.InvocationTargetException;

public abstract class Wrapper
implements BgelObject {
    private final Object originalObject;
    private final Class originalClass;
    private final MetaClass metaClass;

    public Wrapper(Object originalObject, Class originalClass) {
        this(originalObject, originalClass, MetaClassFactory.getMetaClass(originalClass));
    }

    public Wrapper(Object originalObject, Class originalClass, MetaClass metaClass) {
        this.originalObject = originalObject;
        this.originalClass = originalClass;
        this.metaClass = metaClass;
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    public Class getOriginalClass() {
        return this.originalClass;
    }

    @Override
    public Object access(String name) throws IllegalAccessException, BgelAccessException, InvocationTargetException {
        return this.metaClass.access(this.originalObject, name);
    }

    @Override
    public Object invokeMethod(String methodName, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.metaClass.invokeMethod(this.originalObject, methodName, args);
    }

    @Override
    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Wrapper) {
            return this.getOriginalObject().equals(((Wrapper)obj).getOriginalObject());
        }
        return false;
    }

    public String toString() {
        return this.originalObject.toString();
    }
}

